/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

/**
 * コピーをサポートするテーブル・ビュー。
 *
 * <UL>
 * <LI>テーブル・ビューでコピーをサポートする場合の基底クラスです。
 * </UL>
 *
 * @author YAMAMOTO Koji
 * @author KASHIHARA Shinji
 */
public abstract class CopySupportTableView extends ViewPart {

	/** テーブル・ビューアー */
	private AutoColumnWidthTableViewer viewer;

	/** クリップボード */
	private Clipboard clipboard;

	@Override
	public void createPartControl(final Composite parent) {
		viewer = new AutoColumnWidthTableViewer(parent);
		createTableViewer(viewer);
	}

	/**
	 * テーブル・ビューアーを作成するテンプレート・メソッド。
	 * @param viewer テーブル・ビューアー
	 */
	public abstract void createTableViewer(AutoColumnWidthTableViewer viewer);

	/**
	 * クリップボードの取得。
	 * @return クリップボード
	 */
	public Clipboard getClipBoard() {
		if (clipboard == null) {
			clipboard = new Clipboard(getSite().getShell().getDisplay());
		}
		return clipboard;
	}

	@Override
	public void dispose() {
		if (clipboard != null) {
			clipboard.dispose();
		}
		super.dispose();
	}

	/**
	 * 選択の取得。
	 * @return 選択
	 */
	public ISelection getSelection() {
		return viewer.getSelection();
	}

	@Override
	public void setFocus() {
		viewer.getControl().setFocus();
	}

	/**
	 * ビューアーの取得。
	 * @return ビューアー
	 */
	public TableViewer getViewer() {
		return viewer;
	}
}
