/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.ui.viewers.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 翻訳コンテキスト・メニューを持つソース・ビューアーのためのメッセージ。
 *
 * リソースバンドル定義: [TranslationSourceViewerMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class TranslationSourceViewerMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * TranslationSourceViewerMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationSourceViewerMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public TranslationSourceViewerMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/viewers/messages/TranslationSourceViewerMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TranslationSourceViewerMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationSourceViewerMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public TranslationSourceViewerMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/viewers/messages/TranslationSourceViewerMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TranslationSourceViewerMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationSourceViewerMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public TranslationSourceViewerMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/viewers/messages/TranslationSourceViewerMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[TranslationSourceViewerMessages], key[Label.1]
     *
     * [You can use the translation assist\n by pressing Ctrl + SPACE key after selecting the string.] (en)<br>
     * [文字列を選択し、Ctrl + SPACE キーを押下することで\n翻訳アシストが利用可能です。] (ja)<br>
     *
     * @return key[Label.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "You can use the translation assist\n by pressing Ctrl + SPACE key after selecting the string.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationSourceViewerMessages], key[Label.11]
     *
     * [Cut(&amp;X)@Ctrl+X] (en)<br>
     * [切り取り(&amp;X)@Ctrl+X] (ja)<br>
     *
     * @return key[Label.11]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel11() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Cut(&X)@Ctrl+X";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.11");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationSourceViewerMessages], key[Label.12]
     *
     * [&amp;Copy@Ctrl+C] (en)<br>
     * [コピー(&amp;C)@Ctrl+C] (ja)<br>
     *
     * @return key[Label.12]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel12() {
        // 初期値として定義書の値を利用します。
        String strFormat = "&Copy@Ctrl+C";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.12");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationSourceViewerMessages], key[Label.13]
     *
     * [&amp;Paste@Ctrl+V] (en)<br>
     * [貼り付け(&amp;P)@Ctrl+V] (ja)<br>
     *
     * @return key[Label.13]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel13() {
        // 初期値として定義書の値を利用します。
        String strFormat = "&Paste@Ctrl+V";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.13");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationSourceViewerMessages], key[Label.14]
     *
     * [Select &amp;All@Ctrl+A] (en)<br>
     * [すべて選択(&amp;A)@Ctrl+A] (ja)<br>
     *
     * @return key[Label.14]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel14() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Select &All@Ctrl+A";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.14");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationSourceViewerMessages], key[Label.15]
     *
     * [Translation assist@Ctrl+Space] (en)<br>
     * [翻訳アシスト@Ctrl+Space] (ja)<br>
     *
     * @return key[Label.15]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel15() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation assist@Ctrl+Space";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.15");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationSourceViewerMessages], key[Label.16]
     *
     * [Show &amp;TM@Ctrl+T] (en)<br>
     * [TM の表示(&amp;T)@Ctrl+T] (ja)<br>
     *
     * @return key[Label.16]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel16() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Show &TM@Ctrl+T";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.16");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationSourceViewerMessages], key[Label.17]
     *
     * [Show &amp;Glossary@Ctrl+G] (en)<br>
     * [用語集の表示(&amp;G)@Ctrl+G] (ja)<br>
     *
     * @return key[Label.17]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel17() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Show &Glossary@Ctrl+G";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.17");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
