/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/**
 * 一連のウィザード・ページを管理するウィザード基底クラス。
 *
 * @author KASHIHARA Shinji
 */
public abstract class AbstractWorkflowWizard extends Wizard implements IImportWizard, IExportWizard {

	/** 選択。 */
	private IStructuredSelection fSelection;
	/** ダイアログ・ウィザード・ページ。 */
	private AbstractWorkflowDialogWizardPage fDialogWizardPage;

	/**
	 * ジョブを予約するテンプレート・メソッド。
	 */
	abstract protected void scheduleJob();

	/**
	 * {@inheritDoc}
	 */
	public void init(final IWorkbench workbench, final IStructuredSelection selection) {
		fSelection = selection;

		// エディターをすべて保管（引数 true: 未保管の場合はダイアログ表示）
		PlatformUI.getWorkbench().saveAllEditors(true);
	}

	@Override
	public void addPage(final IWizardPage page) {
		super.addPage(page);
		if (page instanceof AbstractWorkflowDialogWizardPage) {
			fDialogWizardPage = (AbstractWorkflowDialogWizardPage) page;
		}
	}

	@Override
	public boolean canFinish() {
		// ウィザードの最初のページでは「完了」ボタンは常に無効
		if (getContainer().getCurrentPage() == getStartingPage()) {
			return false;
		}
		// メイン・ページでは「完了」ボタンの有効/無効は入力値による
		return getPages()[1].isPageComplete();
	}

	@Override
	public boolean performFinish() {
		if (fDialogWizardPage.getWorkflowDialog().hasError()) {
			return false;
		}
		if (fDialogWizardPage.getWorkflowDialog().okPressedPrompt()) {
			scheduleJob();
			return true;
		}
		return false;
	}

	/**
	 * 選択の取得。
	 * @return 選択
	 */
	protected IStructuredSelection getSelection() {
		return fSelection;
	}

	/**
	 * 結果ステータスの取得
	 * @return 結果ステータス
	 */
	protected IStatus getStatus() {
		return fDialogWizardPage.getWorkflowDialog().getResultStatus();
	}
}
