/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.ui.dialogs.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * ワークフローで使用するダイアログの基底クラスのためのメッセージ。
 *
 * リソースバンドル定義: [AbstractWorkflowDialogMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class AbstractWorkflowDialogMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * AbstractWorkflowDialogMessagesクラスのコンストラクタ。
     *
     * 基底名[AbstractWorkflowDialogMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public AbstractWorkflowDialogMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/ui/dialogs/messages/AbstractWorkflowDialogMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * AbstractWorkflowDialogMessagesクラスのコンストラクタ。
     *
     * 基底名[AbstractWorkflowDialogMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public AbstractWorkflowDialogMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/ui/dialogs/messages/AbstractWorkflowDialogMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * AbstractWorkflowDialogMessagesクラスのコンストラクタ。
     *
     * 基底名[AbstractWorkflowDialogMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public AbstractWorkflowDialogMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/ui/dialogs/messages/AbstractWorkflowDialogMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validatePath_E01]
     *
     * [Please enter {0}.] (en)<br>
     * [{0} を入力してください。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[validatePath_E01]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidatePathE01(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please enter {0}.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validatePath_E01");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validatePath_E02]
     *
     * [Cannot specify a period (.) at the beginning or the end of {0}.] (en)<br>
     * [{0} の先頭または末尾に . を指定することはできません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[validatePath_E02]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidatePathE02(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Cannot specify a period (.) at the beginning or the end of {0}.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validatePath_E02");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validatePath_E03]
     *
     * [The resource specified in {0} doesn't exist.] (en)<br>
     * [{0} に指定されたリソースは存在しません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[validatePath_E03]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidatePathE03(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "The resource specified in {0} doesn't exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validatePath_E03");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validatePath_E04]
     *
     * [Please specify a directory in {0}.] (en)<br>
     * [{0} にディレクトリーを指定してください。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[validatePath_E04]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidatePathE04(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please specify a directory in {0}.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validatePath_E04");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validatePath_E05]
     *
     * [Please specify a file in {0}.] (en)<br>
     * [{0} にファイルを指定してください。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[validatePath_E05]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidatePathE05(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please specify a file in {0}.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validatePath_E05");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validatePath_E06]
     *
     * [Extension of {0} is invalid.] (en)<br>
     * [{0} の拡張子が不正です。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[validatePath_E06]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidatePathE06(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Extension of {0} is invalid.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validatePath_E06");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validateFromTo_E01]
     *
     * [{0} is the same as {1}.] (en)<br>
     * [{0} と {1} が同じです。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[validateFromTo_E01]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidateFromToE01(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "{0} is the same as {1}.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validateFromTo_E01");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validateFromTo_E02]
     *
     * [The superior directory of {1} cannot be specified in {0}.] (en)<br>
     * [{0} に {1} の上位ディレトクリーを指定することはできません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[validateFromTo_E02]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidateFromToE02(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "The superior directory of {1} cannot be specified in {0}.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validateFromTo_E02");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validateFromTo_E03]
     *
     * [The subordinate directory of {1} cannot be specified in {0}.] (en)<br>
     * [{0} に {1} の下位ディレトクリーを指定することはできません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[validateFromTo_E03]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidateFromToE03(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "The subordinate directory of {1} cannot be specified in {0}.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validateFromTo_E03");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validateRequire_E01]
     *
     * [Please enter {0}.] (en)<br>
     * [{0} を入力してください。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[validateRequire_E01]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidateRequireE01(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please enter {0}.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validateRequire_E01");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validatePattern_E01]
     *
     * [Format of {0} is invalid.] (en)<br>
     * [{0} の形式が不正です。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[validatePattern_E01]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidatePatternE01(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Format of {0} is invalid.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validatePattern_E01");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[AbstractWorkflowDialogMessages], key[validatePattern_E02]
     *
     * [Format of {0} is invalid.] (en)<br>
     * [{0} の形式が不正です。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[validatePattern_E02]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getValidatePatternE02(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Format of {0} is invalid.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("validatePattern_E02");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
