/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.cat.messages;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 完全一致訳適用機能のためのメッセージ。
 *
 * リソースバンドル定義: [BentenApplyExactMatchMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenApplyExactMatchMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenApplyExactMatchMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenApplyExactMatchMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenApplyExactMatchMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/cat/messages/BentenApplyExactMatchMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenApplyExactMatchMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenApplyExactMatchMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenApplyExactMatchMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/cat/messages/BentenApplyExactMatchMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenApplyExactMatchMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenApplyExactMatchMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenApplyExactMatchMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/cat/messages/BentenApplyExactMatchMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[WindowTitle]
     *
     * [Apply Exact-Match Translations] (en)<br>
     * [完全一致訳の適用] (ja)<br>
     *
     * @return key[WindowTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWindowTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Apply Exact-Match Translations";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WindowTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[JobName]
     *
     * [Applying the exact-match translations...] (en)<br>
     * [完全一致訳の適用中...] (ja)<br>
     *
     * @return key[JobName]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getJobName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Applying the exact-match translations...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("JobName");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[WizardPageTitle]
     *
     * [Welcome] (en)<br>
     * [ようこそ] (ja)<br>
     *
     * @return key[WizardPageTitle]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Welcome";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageTitle");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[WizardPageDescription]
     *
     * [Apply the exact-match translations in TMX to XILFF.] (en)<br>
     * [TMX の完全一致訳を XLIFF に適用します。] (ja)<br>
     *
     * @return key[WizardPageDescription]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageDescription() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Apply the exact-match translations in TMX to XILFF.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageDescription");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[WizardPageLabel1]
     *
     * [This wizard applies the exact-match translations in TMX to XILFF:\n\n 1.  Try to apply the translations to the untranslated translation source.\n 2.  Search the translation unit in TMX that has exact-match, and apply it for the translation unit.] (en)<br>
     * [このウィザードは、TMX の完全一致訳を XLIFF に適用します。\n\n 1.  未翻訳の翻訳対象に対して訳の適用を試みます。\n 2.  翻訳単位と完全一致する TMX を探し、翻訳単位に適用します。] (ja)<br>
     *
     * @return key[WizardPageLabel1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPageLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "This wizard applies the exact-match translations in TMX to XILFF:\n\n 1.  Try to apply the translations to the untranslated translation source.\n 2.  Search the translation unit in TMX that has exact-match, and apply it for the translation unit.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPageLabel1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[WizardPage2Title]
     *
     * [Target Directory] (en)<br>
     * [対象ディレクトリーの指定] (ja)<br>
     *
     * @return key[WizardPage2Title]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Title() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target Directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Title");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[WizardPage2Description]
     *
     * [Specify the target directory.] (en)<br>
     * [対象ディレクトリーを指定します] (ja)<br>
     *
     * @return key[WizardPage2Description]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage2Description() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Specify the target directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage2Description");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[WizardPage3ResultMessage]
     *
     * [Applying the exact-match translations completed.] (en)<br>
     * [完全一致訳の適用が完了しました。] (ja)<br>
     *
     * @return key[WizardPage3ResultMessage]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getWizardPage3ResultMessage() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Applying the exact-match translations completed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("WizardPage3ResultMessage");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[DialogCtrlLabelXliffDir]
     *
     * [XLIFF Directory] (en)<br>
     * [XLIFF ディレクトリー] (ja)<br>
     *
     * @return key[DialogCtrlLabelXliffDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelXliffDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "XLIFF Directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelXliffDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[DialogCtrlLabelTmxDir]
     *
     * [TMX Directory] (en)<br>
     * [TMX ディレクトリー] (ja)<br>
     *
     * @return key[DialogCtrlLabelTmxDir]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlLabelTmxDir() {
        // 初期値として定義書の値を利用します。
        String strFormat = "TMX Directory";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlLabelTmxDir");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[DialogCtrlPreferenceLink]
     *
     * [&lt;a&gt;TM Preference...&lt;/a&gt;] (en)<br>
     * [&lt;a&gt;TM 設定...&lt;/a&gt;] (ja)<br>
     *
     * @return key[DialogCtrlPreferenceLink]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDialogCtrlPreferenceLink() {
        // 初期値として定義書の値を利用します。
        String strFormat = "<a>TM Preference...</a>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DialogCtrlPreferenceLink");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreP001]
     *
     * [Planning the process items...] (en)<br>
     * [処理内容を計画中...] (ja)<br>
     *
     * @return key[CoreP001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Planning the process items...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreP002]
     *
     * [Reading the TM engine...] (en)<br>
     * [TM エンジンを読み込み中...] (ja)<br>
     *
     * @return key[CoreP002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Reading the TM engine...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreP003]
     *
     * [Reading the TM data...] (en)<br>
     * [TM データを読み込み中...] (ja)<br>
     *
     * @return key[CoreP003]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP003() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Reading the TM data...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP003");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreP004]
     *
     * [Processing the directory listings...] (en)<br>
     * [ディレクトリー一覧処理を実行中...] (ja)<br>
     *
     * @return key[CoreP004]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP004() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the directory listings...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP004");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreP005]
     *
     * [Process completed.\n{0}] (en)<br>
     * [処理を完了しました。\n{0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP005]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP005(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Process completed.\n{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreP011]
     *
     * [Processing the XLIFF file [{0}]...] (en)<br>
     * [XLIFF ファイル [{0}] を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP011(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the XLIFF file [{0}]...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreP013]
     *
     * [XLIFF file [{0}] processed.] (en)<br>
     * [XLIFF ファイル [{0}] を処理しました。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreP013]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP013(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "XLIFF file [{0}] processed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP013");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreP101]
     *
     * [Processing the file [{0}] ({1,number}/{2,number})...] (en)<br>
     * [ファイル [{0}] ({1,number}/{2,number}) を処理中...] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.math.BigDecimal型を与えてください。
     * @param arg2 置換文字列{2}を置換する値。java.math.BigDecimal型を与えてください。
     * @return key[CoreP101]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreP101(final String arg0, final BigDecimal arg1, final BigDecimal arg2) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Processing the file [{0}] ({1,number}/{2,number})...";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreP101");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreE001]
     *
     * [Exception occurred while loading the specified class [{0}]: {1}] (en)<br>
     * [指定されたクラス [{0}] のロード時に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE001(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while loading the specified class [{0}]: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreE002]
     *
     * [No driver could be gotten while trying to load from the TM driver manager.] (en)<br>
     * [TM ドライバー・マネージャからロードを試みましたが、1 件もドライバが得られませんでした。] (ja)<br>
     *
     * @return key[CoreE002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "No driver could be gotten while trying to load from the TM driver manager.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreE003]
     *
     * [Could not get the TM engine.] (en)<br>
     * [TM エンジンを取得できませんでした。] (ja)<br>
     *
     * @return key[CoreE003]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE003() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Could not get the TM engine.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE003");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreE004]
     *
     * [XLIFF directory [{0}] could not be found.] (en)<br>
     * [XLIFF ディレクトリー [{0}] は見つかりませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE004]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE004(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "XLIFF directory [{0}] could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreE005]
     *
     * [XLIFF directory [{0}] is actually not a directory.] (en)<br>
     * [XLIFF ディレクトリー [{0}] は、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE005]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE005(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "XLIFF directory [{0}] is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreE006]
     *
     * [TMX directory [{0}] could not be found.] (en)<br>
     * [TMX ディレクトリー [{0}] は見つかりませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE006]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE006(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "TMX directory [{0}] could not be found.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE006");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreE007]
     *
     * [TMX directory [{0}] is actually not a directory.] (en)<br>
     * [TMX ディレクトリー [{0}] は、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE007]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE007(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "TMX directory [{0}] is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE007");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreE011]
     *
     * [Exception occurred while reading the XLIFF file [{0}]: {1}] (en)<br>
     * [XLIFF ファイル [{0}] の読み込み時に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE011]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE011(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while reading the XLIFF file [{0}]: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE011");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenApplyExactMatchMessages], key[CoreE012]
     *
     * [Exception occurred while writing the XLIFF file [{0}]: {1}] (en)<br>
     * [XLIFF ファイル [{0}] の書き込み時に例外が発生しました。: {1}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[CoreE012]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCoreE012(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Exception occurred while writing the XLIFF file [{0}]: {1}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CoreE012");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }
}
