/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.wizards;

import benten.twa.ui.jobs.WorkflowJob;
import benten.twa.ui.wizards.AbstractWorkflowWizard;
import benten.twa.xliff.handler.ExtractXliffFragmentHandler;
import benten.twa.xliff.messages.BentenExtractXliffFragmentMessages;

/**
 * XLIFF フラグメントの抽出
 * 
 * <pre>
 * XLIFF から XLIFF フラグメントを抽出します。
 *   1.  XLIFF から所定の条件に合う翻訳単位を抽出して XLIFF フラグメントを作成します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式断片抽出・マージ機能: XLIFFフラグメント抽出機能」に対応します。
 * 
 * @author YAMAMOTO Koji
 */
public class ExtractXliffFragmentWizard extends AbstractWorkflowWizard {
	/**
	 * XLIFF フラグメント抽出機能のためのメッセージ。
	 */
	protected static final BentenExtractXliffFragmentMessages fMsg = new BentenExtractXliffFragmentMessages();

	@Override
	public void addPages() {
		setWindowTitle(fMsg.getWindowTitle());
		addPage(new ExtractXliffFragmentWizardPage());
		addPage(new ExtractXliffFragmentWizardPage2(getSelection()));
	}

	@Override
	protected void scheduleJob() {
		final WorkflowJob job = new WorkflowJob(fMsg.getJobName());
		job.setStatus(getStatus());
		job.setHandler(new ExtractXliffFragmentHandler());
		job.setCompleteMessage(getWindowTitle(), fMsg.getWizardPage3ResultMessage());
		job.schedule();
	}
}
