package benten.twa.xliff.handler;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.twa.xliff.core.BentenCleanXliffBatchProcess;
import benten.twa.xliff.core.BentenCleanXliffProcessImpl;
import benten.twa.xliff.core.valueobject.BentenCleanXliffProcessInput;
import benten.twa.xliff.dialogs.CleanXliffDialog;
import benten.twa.xliff.messages.BentenCleanXliffMessages;
import benten.twa.xliff.status.BentenCleanXliffStatus;

/**
 * XLIFF フラグメント・クリーン・ハンドラーです。
 * 
 * XLIFF フラグメントのクリーン
 * 
 * <pre>
 * XLIFF ファイルをクリーンします。
 * 
 *   1. 不要な alt-trans を除去します。(Pleiades 訳のほう。prev は除去しない)
 *   2. XLIFF ファイルを整形します。
 * </pre>
 * 
 * @author IGA Tosiki
 */
public class CleanXliffHandler extends AbstractWorkflowHandler {
	/**
	 * XLIFF クリーン機能のためのメッセージ。
	 */
	protected static final BentenCleanXliffMessages fMsg = new BentenCleanXliffMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new CleanXliffDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenCleanXliffStatus status = (BentenCleanXliffStatus) iStatus;

		final BentenCleanXliffProcessInput input = new BentenCleanXliffProcessInput();
		input.setTargetdir(status.getTargetDir().getAbsolutePath());
		new BentenCleanXliffBatchProcess().validateInput(input);
		final BentenCleanXliffProcessImpl process = new BentenCleanXliffProcessImpl() {
			@Override
			protected void beginTask(final int totalWork) {
				monitor.beginTask(null, totalWork);
			}

			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}

			@Override
			public boolean progressInner(final String argProgressMessage) {
				// progressInner 側は UI に連動させません。
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}
}
