/**
 * 
 * このコードは実験用であり、通常の利用では動作しません。
 * 
 *  このビルダーを動作させるには、プロジェクト内の .project ファイルに
 *	buildSpec　要素を追加する必要があります。以下に、例を示します。
 *	<?xml version="1.0" encoding="UTF-8"?>
 *	<projectDescription>
 *		<name>org.eclipse.jst.jsf.doc.user.ja_trans</name>
 *		<comment></comment>
 *		<projects>
 *		</projects>
 *		<buildSpec>
 *	      <buildCommand>
 *	      <name>benten.twa.filter.IncrementalProjectBuilder</name>
 *	      <artuments>
 *	      </artuments>
 *	      </buildCommand>
 *		</buildSpec>
 *		<natures>
 *			<nature>benten.core.bentennature</nature>
 *		</natures>
 *	</projectDescription>
 * 
 * */
package benten.twa.filter.builder;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

import benten.twa.filter.core.BentenExportHtmlProcessImpl;
import benten.twa.filter.core.valueobject.BentenExportHtmlProcessInput;

/**
 * 
 * ファイル保管時に、xliff を翻訳成果物にビルドします。
 * 現在の実装は、xliff -> html 決めうちです。
 * 
 * @author YAMAMOTO Koji
 *
 * */
public class BentenIncrementalProjectBuilder extends IncrementalProjectBuilder {
	
	private static final String SOURCE_DIRECTORY = "/.benten/source";
	private static final String TARGET_DIRECTORY = "/.benten/target";
	private static final String XLIFF_DIRECOTRY = "/xliff";

	/**
	 * コンストラクター
	 */
	public BentenIncrementalProjectBuilder() {
		// TODO Auto-generated constructor stub
	}

	@Override
	protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
		switch (kind) {
		case AUTO_BUILD:

			IResourceDelta delta = getDelta(getProject());
			if (delta == null) {
				return null;
			}

			try {
				final BentenExportHtmlProcessImpl processor = new BentenExportHtmlProcessImpl();
				class IncrementalBuildVisitor implements IResourceDeltaVisitor {

					public boolean visit(IResourceDelta delta) throws CoreException {
						IResource resource = delta.getResource();

						switch (delta.getKind()) {
						case IResourceDelta.CHANGED:
							buildXliff(resource, processor);
							break;
						}
						return true;
					}

				}
				;

				delta.accept(new IncrementalBuildVisitor());
			} finally {
				getProject().refreshLocal(IResource.DEPTH_INFINITE, monitor);
			}

			break;
		default:
			break;
		}

		return null;
	}

	private void buildXliff(IResource resource, BentenExportHtmlProcessImpl processor) {
		if (resource instanceof IFile && resource.getName().endsWith(".xlf")) {

			BentenExportHtmlProcessInput input = new BentenExportHtmlProcessInput();
			String projedtUrl;
			try {
				projedtUrl = resource.getProject().getLocation().makeAbsolute().toFile().getCanonicalPath();
				input.setSourcehtmldir(projedtUrl + SOURCE_DIRECTORY);
				input.setSourcexliffdir(projedtUrl + XLIFF_DIRECOTRY);
				input.setTargetdir(projedtUrl + TARGET_DIRECTORY);

				String htmlPath = resource.getFullPath().toString().replaceFirst(
						Pattern.quote(resource.getProject().getFullPath() + XLIFF_DIRECOTRY), SOURCE_DIRECTORY).replaceFirst(
						"\\.[^\\.]+$", "");
				processor.setInput(input);
				processor.processFile(new File(projedtUrl + htmlPath), "");
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

}
