/*******************************************************************************
 * Copyright (c) 2010 IGA Tosiki
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.engine.googletranslate;

import benten.cat.glossary.core.BentenGlossaryDriver;
import benten.cat.glossary.core.BentenGlossaryDriverManager;
import benten.cat.glossary.core.BentenGlossaryEngine;

/**
 * Google Translate 用語集ドライバー。
 *
 * <UL>
 * <LI>このクラスは、用語集エンジンの切り替えテストのためのテストクラスです。
 * <LI>実際の Benten 基本セットには含まれません。
 * </UL>
 * 
 * @author IGA Tosiki
 */
public class GoogleTranslateGlossaryDriver implements BentenGlossaryDriver {
	/**
	 * このエンジンのドライバー名。
	 */
	public static final String DRIVER_NAME = "google"; //$NON-NLS-1$

	static {
		// 自分を登録。
		BentenGlossaryDriverManager.registerDriver(new GoogleTranslateGlossaryDriver());
	}

	/**
	 * {@inheritDoc}
	 */
	public String getName() {
		return DRIVER_NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	public BentenGlossaryEngine getEngineInstance() {
		return new GoogleTranslateGlossaryEngine();
	}
}
