package benten.cat.tm.engine.googletranslate.ui;

import org.osgi.framework.BundleContext;

import benten.cat.tm.core.BentenTmDriver;
import benten.cat.tm.core.BentenTmDriverManager;
import benten.cat.tm.core.BentenTmEngine;
import benten.cat.tm.engine.AbstractBentenTmEnginePlugin;
import benten.cat.tm.engine.googletranslate.GoogleTranslateTmDriver;
import benten.cat.tm.engine.googletranslate.ui.messages.GoogleTranslateTmPluginMessages;

/**
 * このクラスは、Benten Google Translate TM エンジンです。
 * 
 * <UL>
 * <LI>このプラグインを Eclipse 上で有効化するためのプラグイン・クラスです。
 * </UL>
 * 
 * @author IGA Tosiki
 * @author YAMAMOTO Koji
 */
public class GoogleTranslateTmPlugin extends AbstractBentenTmEnginePlugin {
	/** 共用インスタンス。 */
	private static GoogleTranslateTmPlugin plugin;

	/**
	 * このプラグインのためのメッセージ。
	 */
	protected static final GoogleTranslateTmPluginMessages fMsg = new GoogleTranslateTmPluginMessages();

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	@Override
	public AbstractBentenTmEnginePlugin getPluginDefault() {
		return plugin;
	}

	@Override
	public BentenTmDriver getDriver() {
		try {
			// 自らのドライバーを自己登録します。
			Class.forName("benten.cat.tm.engine.googletranslate.GoogleTranslateTmDriver"); //$NON-NLS-1$
		} catch (final ClassNotFoundException e) {
			log("Fail to read Google Translate TM engine.");
			log(e);
		}

		return BentenTmDriverManager.getDriver(GoogleTranslateTmDriver.DRIVER_NAME);
	}

	@Override
	public BentenTmEngine getEngine() {
		if (fEngine == null) {
			fEngine = getDriver().getEngineInstance();
		}

		return fEngine;
	}

	@Override
	public void load() {
		// 何もしません。
	}
}
