#ifndef URG_CTRL_H
#define URG_CTRL_H

/*!
  \file
  \brief URG 

  \author Satofumi KAMIMURA

  $Id$
*/

#include "RangeSensorInterface.h"
#include <memory>

class SensorParameter;


class UrgCtrl : public RangeSensorInterface {
  UrgCtrl(const UrgCtrl& rhs);
  UrgCtrl& operator = (const UrgCtrl& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  enum {
    NotConnected = -1,
  };

  typedef enum {
    Manual,
    Auto,
  } CaptureMode;
  explicit UrgCtrl(CaptureMode mode = Manual);
  ~UrgCtrl(void);

  const char* what(void);

  enum {
    DefaultBaudrate = 115200,
  };
  bool connect(const char* device, long baudrate = DefaultBaudrate);
  void disconnect(void);

  enum {
    VEND = 0,			// x_
    PROD,			// i
    FIRM,			// t@[EFAo[W
    PROT,			// vgRo[W
    SERI,			// ZTŗLVAԍ
  };
  bool getVersionInfo(std::vector<std::string>& lines);
  bool loadSensorParameter(SensorParameter* parameter);

  // f[^擾
  int capture(long data[], size_t max_size);

  // 擾obt@̐ݒ
  void setBufferNum(size_t size);

  // O capture() ̃^CX^vԂ
  unsigned long getTimestamp(void);

  // t[̊Ԉ
  void setFrameSkipFrames(size_t skip_frames);

  // f[^܂Ƃ߂O[v
  void setDataGroups(size_t groups);

  // 擾͈͂̎w
  void setCaptureRange(int first_index, int last_index);

  // ŏ苗̎擾
  long getMinDistance(void);

  // őf[^TCY̎擾
  int getMaxDataLength(void);

  // [Ȕo͐
  void setLaserOutput(bool on);

  // pxϊ
  double index2rad(const int index);
  int rad2index(const double radian);
};

#endif /* !URG_CTRL_H */
