#ifndef SCIP_HANDLE_H
#define SCIP_HANDLE_H

/*!
  \file
  \brief SCIP nh

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>
#include <vector>

class ConnectionInterface;
class SensorParameter;


class ScipHandler {
  ScipHandler(const ScipHandler& rhs);
  ScipHandler& operator = (const ScipHandler& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  ScipHandler(void);
  ~ScipHandler(void);

  const char* what(void);

  void setConnection(ConnectionInterface* con);
  void disconnect(void);
  bool isConnected(void);
  bool adjustBaudrate(long baudrate);
  bool setBaudrate(long baudrate);
  bool getVersionInfo(std::vector<std::string>& lines);
  bool loadSensorParameter(SensorParameter* parameter);
  void setCaptureTimes(size_t times);
  void sendCaptureMessage(void);
  int recvCaptureData(long* data, size_t max_size,
		      size_t& timestamp, int timeout);
  int capture(long data[], size_t max_size, size_t& timestamp);
  void setFrameSkipFrames(size_t skip_frames);
  void setDataGroups(size_t groups);
  void setCaptureRange(int first_index, int last_index);
  long getMinDistance(void);
  int getMaxDataLength(void);
  void setLaserOutput(bool on);
  double index2rad(const int index);
  int rad2index(const double radian);
};

#endif /* !SCIP_HANDLE_H */
