#ifndef JOYSTICK_INTERFACE_H
#define JOYSTICK_INTERFACE_H

/*!
  \file
  \brief WCXeBbNpC^[tF[X

  \author Satofumi KAMIMURA

  $Id$
*/

#include <stddef.h>


class JoystickInterface {
public:
  virtual ~JoystickInterface(void) {}

  virtual const char* what(void) = 0;

  virtual size_t getNumAxis(void) = 0;

  virtual size_t getNumButtons(void) = 0;

  virtual short getAxisValue(size_t index) = 0;

  virtual bool isButtonPressed(size_t index) = 0;
};

#endif /* !JOYSTICK_INTERFACE_H */
