/*!
  \file
  \brief TCP/IP ڑp|[g

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TcpipAccept.h"
#include "TcpipCtrl.h"
#include "NetInit.h"
#include "LogManager.h"
#include <string>


/*!
  \brief TcpipAccept ̓NX
*/
struct TcpipAccept::pImpl : private NetInit {
  std::string error_message;
  IPaddress ip;
  TCPsocket accept_socket;
  SDLNet_SocketSet accept_set;
  bool isActive;

  pImpl(void)
    : error_message("no error"),
      accept_socket(NULL), accept_set(NULL), isActive(false) {
  }

  bool errorReturn(const char* base_message) {

    LogManager* log = LogManager::getObject();
    std::string message = base_message + std::string(SDLNet_GetError());
    log->write(LogManager::Error, message.c_str());

    return false;
  }
};


TcpipAccept::TcpipAccept(void) : pimpl(new pImpl) {
}


TcpipAccept::~TcpipAccept(void) {
  deactivate();
}


const char* TcpipAccept::what(void) {
  return pimpl->error_message.c_str();
}


bool TcpipAccept::activate(unsigned short port) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  if (isActivated()) {
    return true;
  }

  if (SDLNet_ResolveHost(&pimpl->ip, NULL, port) < 0) {
    return pimpl->errorReturn("TcpipAccept::activate(): ");
  }
  pimpl->accept_socket = SDLNet_TCP_Open(&pimpl->ip);
  if (pimpl->accept_socket == NULL) {
    return pimpl->errorReturn("TcpipAccept::activate(): ");
  }
  pimpl->accept_set = SDLNet_AllocSocketSet(1);
  if (pimpl->accept_set == NULL) {
    return pimpl->errorReturn("TcpipAccept::activate(): ");
  }
  if (SDLNet_TCP_AddSocket(pimpl->accept_set, pimpl->accept_socket) < 0) {
    return pimpl->errorReturn("TcpipAccept::activate(): ");
  }
  pimpl->isActive = true;
  return true;
#else
  return false;
#endif
}


void TcpipAccept::deactivate(void) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  if (! isActivated()) {
    return;
  }

  if (SDLNet_TCP_DelSocket(pimpl->accept_set, pimpl->accept_socket) < 0) {
    pimpl->errorReturn("TcpipAccept::deactivate(): ");
    return;
  }

  SDLNet_FreeSocketSet(pimpl->accept_set);
  pimpl->accept_set = NULL;

  SDLNet_TCP_Close(pimpl->accept_socket);
  pimpl->accept_socket = NULL;

  pimpl->isActive = false;
#endif
}


bool TcpipAccept::isActivated(void) {
  return pimpl->isActive;
}


/*!
  \todo G[bZ[WOXV̂ɒu
*/
TcpipCtrl* TcpipAccept::accept(int timeout, SocketSet* socketSet) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  if (isActivated() == false) {
    pimpl->error_message = "TcpipAccept::accept() is invalid.";
    return NULL;
  }
  int n = SDLNet_CheckSockets(pimpl->accept_set, timeout);
  if ((n <= 0) || (SDLNet_SocketReady(pimpl->accept_socket) < 0)) {
    return NULL;
  }
  TCPsocket socket = SDLNet_TCP_Accept(pimpl->accept_socket);
  if (socket == NULL) {
    return NULL;
  }
  return new TcpipCtrl(socketSet, socket);
#else
  return NULL;
#endif
}
