#ifndef SOCKET_SET_H
#define SOCKET_SET_H

/*!
  \file
  \brief \PbgZbgǗ

  \author Satofumi KAMIMURA

  $Id$
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
#include <SDL_net.h>
#else
class TCPsocket;
#endif
#include <memory>

class TcpipCtrl;


/*!
  \brief \PbgZbgǗ
*/
class SocketSet {
  SocketSet(const SocketSet& rhs);
  SocketSet& operator = (const SocketSet& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  explicit SocketSet(size_t size = 1);
  ~SocketSet(void);

  bool add(TCPsocket socket);
  void del(TCPsocket socket);
  size_t check(int timeout);
};

#endif /* !SOCKET_SET_H */
