#ifndef LOG_MANAGER_H
#define LOG_MANAGER_H

/*!
  \file
  \brief OǗNX

  \author Satofumi KAMIMURA

  $Id$

  \todo ID ԍŏ݃t@Cwł悤ɕύX
*/

#include <memory>


/*!
  \brief OǗNX
*/
class LogManager {
  LogManager(void);
  LogManager(const LogManager& rhs);
  LogManager& operator = (const LogManager& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  /*!
    \brief G[x
  */
  typedef enum {
    NoWrite = 0,		//!< SbZ[W̖
    Attack,			//!< NbN
    Error,			//!< G[
    Warning,			//!< x
    Notice,			//!< 
    All,			//!< SbZ[W̋L^
  } ErrorLevel;

  ~LogManager(void);
  static LogManager* getObject(int id = 0);

  /*!
    \brief Ot@Cw肷

    ̊֐́Aŏ write() Ă΂OɌĂяoȂ΂ȂȂB

    \param fileName [i] Ot@C
  */
  void setFileName(const char* fileName, int id = 0);


  /*!
    \brief t@CɋL^ȂG[xw肷

    w肳ꂽG[xႢL^t@Cɏ܂ȂB

    \param mask [i] ݂sG[x

    \code
    LogManager* log = LogManager::getObject();
    log->setFileName("error_log.txt");

    // Warning, Notice ̓t@Cɏ܂ȂȂ
    log->setLogMask(Error);
    ...

    log->write(Error, "error!");	// ܂
    log->write(Warning, "warning!"); 	// ܂Ȃ
    \endcode
  */
  void setLogMask(const ErrorLevel level, int id = 0);


  /*!
    \brief OɃbZ[W

    ̃\bhɃbZ[W͉sċL^B

    \param level [i] Ox
    \param message [i] bZ[W
  */
  void write(const ErrorLevel level, const char* message);
};

#endif /* !LOG_MANAGER_H */
