#ifndef GRID_TYPES_H
#define GRID_TYPES_H

/*!
  \file
  \brief Obh^̒`

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


class Angle {
public:
  double toRad(void) const;
};


class Grid {
  explicit Grid(void);
  Grid& operator = (const Grid& rhs);

public:
  int x;
  int y;

  explicit Grid(const int x, const int y);
  Grid(const Grid& rhs);
};


class Position {
public:
  int x;
  int y;
  double radian;

  explicit Position(void);
  explicit Position(const int x, const int y, const Angle angle);
  Position(const Position& rhs);
  Position& operator = (const Position& rhs);
  ~Position(void);
};


class Grid3D {
  Grid3D& operator = (const Grid3D& rhs);

public:
  int x;
  int y;
  int z;

  explicit Grid3D(void);
  Grid3D(const Grid3D& rhs);
  ~Grid3D(void);
};


extern Angle deg(const int degree);

extern void set_Position(Position* obj, int x, int y, double radian);
extern void set_Grid3D(Grid3D* obj, int x, int y, int z);

#endif /* !GRID_TYPES_H */
