/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import java.util.HashMap;
import java.util.Map;

public enum Keyword {
    SymBEGIN("BEGIN", true),
    SymBREAK("break", true),
    SymCATCH("catch", true),
    SymCONTINUE("continue", true),
    SymDELETE("delete", true),
    SymDO("do", true),
    SymELSE("else", true),
    SymEND("END", true),
    SymEXIT("exit", true),
    SymFINALLY("finally", true),
    SymFOR("for", true),
    SymFUNCTION("function", true),
    SymGETLINE("getline", true),
    SymHAS("has", true),
    SymIF("if", true),
    SymIMPORT("import", true),
    SymINVOKE("invoke", true),
    SymNEXT("next", true),
    SymNEXTFILE("nextfile", true),
    SymPACKAGE("package", true),
    SymPRINT("print", true),
    SymPRINTF("printf", true),
    SymRETURN("return", true),
    SymTHROW("throw", true),
    SymTRY("try", true),
    SymVAL("val", true),
    SymVAR("var", true),
    SymWHILE("while", true),
    SyyAnnotation("Annotation", false),
    SyyARRAY("ARRAY", false),
    SyyASSIGN("ASSIGN", false),
    SyyBDO("DO", false),
    SyyBFOR("FOR", false),
    SyyBWHILE("WHILE", false),
    SyyCALL("CALL", false),
    SyyFN("Func", false),
    SyyFNI("FnI", false),
    SyyFNP("FnP", false),
    SyyFVal("FVAL", false),
    SyyFValFuture("FVALATOM", false),
    SyyNAME("NAME", false),
    SyyNEW("NEW", false),
    SyyQIF("QIF", false),
    SyySIMPLE("SIMPLE", false);

    private static final Map<String, Keyword> CREVERCE_MAP;
    private final String id;
    private final boolean isSymbol;

    private Keyword(String x, boolean b) {
        this.id = x;
        this.isSymbol = b;
    }

    public static Keyword apply(String x) {
        return CREVERCE_MAP.get(x);
    }

    public static boolean contains(String x) {
        return CREVERCE_MAP.containsKey(x);
    }

    public static String toName(Keyword x) {
        return x.id;
    }

    public final String toString() {
        return "'" + this.id;
    }

    static {
        CREVERCE_MAP = new HashMap<String, Keyword>();
        for (Keyword x : Keyword.values()) {
            if (!x.isSymbol) continue;
            CREVERCE_MAP.put(x.id, x);
        }
    }
}

