/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.exception;

import org.jetbrains.annotations.Nullable;

/**
 * return 割り込み.
 *
 * @author kunio himei.
 */
public final class ReturnException extends RuntimeException {

    //* for Interpreter
    private final Object value;

    public ReturnException(Object e) {
        this.value = e;
    }

    @Nullable
    public Object value() {
        return this.value;
    }
}