/*
 * Decompiled with CFR 0.152.
 */
package plus.spawn;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import plus.io.Device;
import plus.io.Io;
import plus.io.IoHelper;
import plus.spawn.system.UtilInterface;

public final class SimpleDate
extends FilterWriter
implements UtilInterface {
    private static final String USAGE = "Usage: date [OPTION]... [+FORMAT]\nDisplay the current time in the given FORMAT.\n\n      --help      display this help and exit (should be alone)";
    private final String format;

    public SimpleDate(String[] args, Writer output) {
        super(output);
        StringBuilder flags = new StringBuilder();
        String fmt = null;
        for (String arg : args) {
            char c = arg.charAt(0);
            if ('-' == c) {
                flags.append(arg.substring(1));
                continue;
            }
            if ('+' != c) continue;
            fmt = arg.substring(1);
        }
        this.format = fmt;
        if (0 <= flags.indexOf("v")) {
            StringBuilder sb = new StringBuilder("`date");
            if (0 < flags.length()) {
                sb.append(" -").append((CharSequence)flags);
            }
            if (null != fmt) {
                sb.append(" +").append(fmt);
            }
            System.err.println(sb.append('`'));
        }
    }

    public static void main(String[] args) throws IOException {
        if (0 != args.length && args[0].startsWith("--help")) {
            System.out.println(USAGE);
        } else {
            new SimpleDate(args, Device.openOutput("", "/dev/stdout")).close();
        }
    }

    @Override
    public void close() throws IOException {
        Date date = new Date();
        String x = null == this.format ? date.toString() : new SimpleDateFormat(this.format).format(date);
        IoHelper.writeln(this.out, x, true);
        Io.close(this.out);
    }

    @Override
    public int exitValue() {
        return 0;
    }

    @Override
    public boolean hasInput() {
        return false;
    }
}

