<?php
/************************************************************************/
/* ATutor														        */
/************************************************************************/
/* Copyright (c) 2002-2010                                              */
/* Inclusive Design Institute                                           */
/* http://atutor.ca												        */
/*                                                                      */
/* This program is free software. You can redistribute it and/or        */
/* modify it under the terms of the GNU General Public License          */
/* as published by the Free Software Foundation.				        */
/************************************************************************/
// $Id$

if (!defined('AT_INCLUDE_PATH')) { exit; }

if (isset($_GET['reset_filter'])) {
	unset($_GET['category_id']);
}
if (!isset($_GET['category_id'])) {
	// Suppress warnings
	$_GET['category_id'] = -1;
}
require(AT_INCLUDE_PATH.'../mods/_standard/tests/lib/test_result_functions.inc.php');
?>
<br style="clear:both;" />
<fieldset class="group_form" style="width:93%"><legend class="group_form"><?php echo _AT('category'); ?></legend>
	<form method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>">
		<input type="hidden" name="tid" value="<?php echo $tid; ?>" />
		<div class="row">
			<label for="cats"><?php echo _AT('category'); ?></label><br />
			<select name="category_id" id="cats">
				<option value="-1"><?php echo _AT('cats_all'); ?></option>
				<?php print_question_cats($_GET['category_id']); ?>
			</select>
		</div>
		<div class="row buttons">
			<input type="submit" name="filter" value="<?php echo _AT('filter'); ?>" />
			<input type="submit" name="reset_filter" value="<?php echo _AT('reset_filter'); ?>" />
		</div>
		</form>
</fieldset>


<?php

$cats = array();
if ($_GET['category_id'] >= 0) {
	$sql    = "SELECT * FROM %stests_questions_categories WHERE course_id=%d AND category_id=%d ORDER BY title";
    $rows_categories	= queryDB($sql, array(TABLE_PREFIX, $_SESSION['course_id'], $_GET['category_id']));
} else {
	$sql    = "SELECT * FROM %stests_questions_categories WHERE course_id=%d ORDER BY title";
    $rows_categories	= queryDB($sql, array(TABLE_PREFIX, $_SESSION['course_id']));
}

if ($_GET['category_id'] <= 0) {
	$cats[] = array('title' => _AT('cats_uncategorized'), 'category_id' => 0);
}

foreach($rows_categories as $row){
	$cats[] = $row;
}

	$cols = 3;
?>
<?php if ($tid): ?>
	<form method="post" action="<?php echo AT_BASE_HREF; ?>mods/_standard/tests/add_test_questions_confirm.php" name="form">
<?php else: ?>
	<form method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>" name="form">
<?php endif; ?>
<br style="clear:both;" />
<table class="data" summary="">
<thead>
<tr>
	<th scope="col">&nbsp;</th>
	<th scope="col"><?php echo _AT('question'); ?></th>
	<th scope="col"><?php echo _AT('type'); ?></th>
</tr>
</thead>
<tfoot>
<?php if ($tid): ?>
	<tr>
		<td colspan="3">
			<input type="hidden" name="tid" value="<?php echo $tid; ?>" />
			<input type="submit" name="submit" value="<?php echo _AT('add_to_test_survey'); ?>" accesskey="s" />
			<input type="submit" name="cancel" value="<?php echo _AT('cancel'); ?>" />
		</td>
	</tr>
<?php else: ?>
	<tr>
		<td colspan="3">
			<input type="submit" name="edit" value="<?php echo _AT('edit'); ?>" /> 
			<input type="submit" name="preview" value="<?php echo _AT('preview'); ?>" />
			<input type="submit" name="export" value="<?php echo _AT('export'); ?>" />
			<select name='qti_export_version' >
				<option selected='selected' value='1.2.1'>QTI 1.2.1</option>
				<option value='2.1'>QTI 2.1</option>
			</select>
			<input type="submit" name="delete" value="<?php echo _AT('delete'); ?>" />
		</td>
	</tr>
<?php endif; ?>
</tfoot>
<tbody>
<?php

$question_flag = FALSE;

//output categories
foreach ($cats as $cat) {
	//ouput questions

	$sql	= "SELECT * FROM %stests_questions WHERE course_id=%d AND category_id=%d ORDER BY question";
	$rows_questions	= queryDB($sql, array(TABLE_PREFIX, $_SESSION['course_id'], $cat['category_id']));
	
	if (count($rows_questions) > 0) {
		$question_flag = TRUE;
		echo '<tr>';
		echo '<th colspan="'.$cols.'">';

		echo '<input type="checkbox" name="cat'.$cat['category_id'].'" id="cat'.$cat['category_id'].'" onclick="javascript:selectCat('.$cat['category_id'].', this);" /><label for="cat'.$cat['category_id'].'">'.$cat['title'].'</label>';
		echo '</th>';
		echo '</tr>';
        foreach($rows_questions as $row){
			echo '<tr onmousedown="document.form[\'q' . $row['question_id'] . '\'].checked = !document.form[\'q' . $row['question_id'] . '\'].checked; togglerowhighlight(this, \'q'.$row['question_id'].'\');" id="rq'.$row['question_id'].'">';
			echo '<td>';
			echo '<input type="checkbox" value="'.$row['question_id'].'|'.$row['type'].'" name="questions['.$cat['category_id'].'][]" id="q'.$row['question_id'].'" onmouseup="this.checked=!this.checked" /></td>';
			echo '<td>';
			echo '<a title="'.strip_tags($row[question]).'">';
			echo AT_print((validate_length($row['question'], 100, VALIDATE_LENGTH_FOR_DISPLAY)), 'tests_questions.question');
			echo '</a>';
			echo '</td>';
			echo '<td>';
			$o = TestQuestions::getQuestion($row['type']);
			$o->printName();
					
			echo '</td>';
			
			echo '</tr>';

		} 
	} 
}  
if (!$question_flag) {
	echo '<tr><td colspan="'.$cols.'">'._AT('none_found').'</td></tr>';
}
?>
</tbody>
</table>
</form>

<script type="text/javascript">
// <!--
	function selectCat(catID, cat) {
		for (var i=0;i<document.form.elements.length;i++) {
			var e = document.form.elements[i];
			if ((e.name == 'questions[' + catID + '][]') && (e.type=='checkbox')) {
				e.checked = cat.checked;
				togglerowhighlight(document.getElementById("r" + e.id), e.id);
			}
		}
	}
	
function togglerowhighlight(obj, boxid) {
	if (document.getElementById(boxid).checked) {
		obj.className = 'selected';
	} else {
		obj.className = '';
	}
}
// -->
</script>
