<?php
/****************************************************************/
/* ATutor														*/
/****************************************************************/
/* Copyright (c) 2002-2008                                      */
/* Written by Greg Gay, Joel Kronenberg & Chris Ridpath         */
/* Inclusive Design Institute                                   */
/* http://atutor.ca												*/
/*                                                              */
/* This program is free software. You can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation.				*/
/****************************************************************/
// $Id$
define('AT_INCLUDE_PATH', '../../../include/');
require (AT_INCLUDE_PATH.'vitals.inc.php');
authenticate(AT_PRIV_READING_LIST);
tool_origin();
if (isset($_GET['edit'])) {
	$_GET['resource_id'] = intval($_GET['resource_id']);

	// what kind of resource is user going to edit?
	$sql = "SELECT type FROM %sexternal_resources WHERE course_id=%d AND resource_id=%d";
	$row = queryDB($sql, array(TABLE_PREFIX, $_SESSION['course_id'], $_GET['resource_id']), TRUE);
	
	if(count($row) > 0){
		header('Location: add_resource_'.substr($_rl_types[$row['type']], 3).'.php?id='. $_GET['resource_id']. SEP. 'page_return=display_resources.php');
	}
} else if (isset($_GET['delete'])) {
	$_GET['resource_id'] = intval($_GET['resource_id']);
	header('Location: delete_resource.php?id='. $_GET['resource_id']);
	exit;
} else if (isset($_GET['create'])){
	$_GET['new_resource'] = intval($_GET['new_resource']);
	if (isset($_rl_types[$_GET['new_resource']])){
		// Note: the '3' substring is used here to strip out the 'rl_' from the name
		header('Location: add_resource_'.substr($_rl_types[$_GET['new_resource']], 3).'.php'. '?page_return=display_resources.php');
		exit;
	}
}

require(AT_INCLUDE_PATH.'header.inc.php');

$sql = "SELECT title, resource_id FROM %sexternal_resources WHERE course_id=%d AND type=%d ORDER BY title";
$rows_books = queryDB($sql, array(TABLE_PREFIX, $_SESSION[course_id], RL_TYPE_BOOK));
$num_books = count($rows_books);
?>
<div class="input-form" style="width: 90%">
	<fieldset class="group_form"><legend class="group_form"><?php echo _AT('create'); ?></legend>
<form method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>">
	<div class="row">
		<label for="question"><?php echo _AT('rl_type_of_resource'); ?></label><br />
		<select name="new_resource" class="dropdown" id="type">

		<?php foreach ($_rl_types as $key => $value): ?>
			<option value="<?php echo $key; ?>"><?php echo _AT($value); ?></option>
		<?php endforeach; ?>

		</select>
	</div>

	<div class="row buttons">
		<input type="submit" name="create" value="<?php echo _AT('create'); ?>" />
	</div>
</form>
</fieldset>
</div>
<?php
$sql = "SELECT * FROM %sexternal_resources WHERE course_id=%d ORDER BY type";
$rows_resources = queryDB($sql, array(TABLE_PREFIX, $_SESSION[course_id]));
?>

<form method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>" name="form">
<table class="data" style="width: 90%;">
<thead>
<tr>
	<th>&nbsp;</th>
	<th><?php echo _AT('type'); ?></th>
	<th><?php echo _AT('title'); ?></th>
	<th><?php echo _AT('author'); ?></th>
</tr>
</thead>
<tfoot>
<tr>
	<td colspan="6"><input type="submit" name="edit" value="<?php echo _AT('edit'); ?>" /> 
				    <input type="submit" name="delete" value="<?php echo _AT('delete'); ?>" /></td>
</tr>
</tfoot>
<?php 
    if(count($rows_resources) > 0):
?>
<tbody>
		<?php $first=true; // check the first radio button ?>
		<?php 
		foreach($rows_resources as $row){
		?>
			<tr onmousedown="document.form['t<?php echo $row['resource_id']; ?>'].checked = true; rowselect(this);" id="r_<?php echo $row['resource_id']; ?>_0">
				
			<td><input type="radio" id="t<?php echo $row['resource_id'];?>" name="resource_id" value="<?php echo $row['resource_id']; ?>"
			<?php if ($first == true){ echo 'checked="checked"'; $first=false;} ?>/></td>
			<td><?php echo _AT($_rl_types[$row['type']]); ?></td>
			<td><label for="t<?php echo $row['resource_id'];?>"><strong><?php echo AT_print($row['title'], 'input.text'); ?></strong></label></td>
			<td><?php echo AT_print($row['author'], 'input.text'); ?></td>
			</tr>
		<?php } ?>
</tbody>
<?php else: ?>
	<tr>
		<td colspan="2"><strong><?php echo _AT('none_found'); ?></strong></td>
	</tr>
<?php endif; ?>
</table>
</form>

<?php require (AT_INCLUDE_PATH.'footer.inc.php'); ?>