#encoding utf8
;
; only language names here, so the language dialog comes up faster
; (used to read all language files)
;
languageFileExists      true

LIST_OF_OFFERED_LANGUAGES #( \
  'af' \
  "'ar' -- Cannot offer this right now: need right-to-left text support " \
  'cs' \
  'da' \
  'de' \
  'en-uk' \
  'en-us' \
  'el' \
  'eo' \
  'es' \
  'fr' \
  'fi' \
  "'he' -- Cannot offer this right now: need right-to-left text support " \
  'hi' \
  'hr' \
  'hu' \
  'it' \
  'ja' \
  'ko' \
  'la' \
  'nl' \
  'no' \
  'pl' \
  'pt' \
  'pt-br' \
  'ro' \
  'ru' \
  'sk' \
  'sl' \
  'sv' \
  'th' \
  'tr' \
  'zh' \
  'zh-trad' \
)

;
; flags - add one if you add one above.
;
FLAG_af     'bitmaps/xpmBitmaps/countries/s_africa.xpm'
FLAG_ar     'bitmaps/xpmBitmaps/languages/arabic.xpm'
FLAG_cs     'bitmaps/xpmBitmaps/countries/czech.xpm'
FLAG_da     'bitmaps/xpmBitmaps/countries/denmark.xpm'
FLAG_de     'bitmaps/xpmBitmaps/countries/germany.xpm'
FLAG_el     'bitmaps/xpmBitmaps/countries/greece.xpm'
FLAG_en_us  'bitmaps/xpmBitmaps/countries/usa.xpm'
FLAG_en_uk  'bitmaps/xpmBitmaps/countries/uk.xpm'
FLAG_eo     'bitmaps/xpmBitmaps/languages/esperanto.xpm'
FLAG_es     'bitmaps/xpmBitmaps/countries/spain.xpm'
FLAG_fi     'bitmaps/xpmBitmaps/countries/finland.xpm'
FLAG_fr     'bitmaps/xpmBitmaps/countries/france.xpm'
FLAG_he     'bitmaps/xpmBitmaps/countries/israel2.xpm'
FLAG_hi     'bitmaps/xpmBitmaps/countries/india.xpm'
FLAG_hr     'bitmaps/xpmBitmaps/countries/croatia.xpm'
FLAG_hu     'bitmaps/xpmBitmaps/countries/hungary.xpm'
FLAG_it     'bitmaps/xpmBitmaps/countries/italy.xpm'
FLAG_ja     'bitmaps/xpmBitmaps/countries/japan.xpm'
FLAG_ko     'bitmaps/xpmBitmaps/countries/s_korea.xpm'
FLAG_la     'bitmaps/xpmBitmaps/languages/latin.xpm'
FLAG_nl     'bitmaps/xpmBitmaps/countries/netherlands.xpm'
FLAG_no     'bitmaps/xpmBitmaps/countries/norweg.xpm'
FLAG_pl     'bitmaps/xpmBitmaps/countries/poland.xpm'
FLAG_pt     'bitmaps/xpmBitmaps/countries/portug.xpm'
FLAG_pt_br  'bitmaps/xpmBitmaps/countries/brazil.xpm'
FLAG_ro     'bitmaps/xpmBitmaps/countries/romania.xpm'
FLAG_ru     'bitmaps/xpmBitmaps/countries/russia.xpm'
FLAG_sk     'bitmaps/xpmBitmaps/countries/slovakia.xpm'
FLAG_sl     'bitmaps/xpmBitmaps/countries/slovenia.xpm'
FLAG_sv     'bitmaps/xpmBitmaps/countries/sweden.xpm'
FLAG_th     'bitmaps/xpmBitmaps/countries/thailand.xpm'
FLAG_tr     'bitmaps/xpmBitmaps/countries/turkey.xpm'
FLAG_zh       'bitmaps/xpmBitmaps/countries/china.xpm'
FLAG_zh_trad  'bitmaps/xpmBitmaps/countries/taiwan.xpm'

;
; language name in english.
;
'LANG_af'       'Afrikaans'
'LANG_ar'       'Arabic'
'LANG_az'       'Azerbaijani'
'LANG_be'       'Byelorussian'
'LANG_bg'       'Bulgarian'
'LANG_br'       'Breton'
'LANG_ca'       'Catalan'
'LANG_co'       'Corsican'
'LANG_cs'       'Czech'
'LANG_cy'       'Welsh'
'LANG_da'       'Danish'
'LANG_de'       'German'
'LANG_el'       'Greek'
'LANG_en_us'    'English (US)'
'LANG_en_uk'    'English (UK)'
'LANG_eo'       'Esperanto'
'LANG_es'       'Spanish'
'LANG_et'       'Estonian'
'LANG_eu'       'Basque'
'LANG_fa'       'Persian (Farsi)'
'LANG_fi'       'Finnish'
'LANG_fr'       'French'
'LANG_ga'       'Irish'
'LANG_gd'       'Scots Gaelic'
'LANG_gl'       'Galician'
'LANG_he'       'Hebrew'
'LANG_hi'       'Hindi'
'LANG_hr'       'Croatian'
'LANG_hu'       'Hungarian'
'LANG_ia'       'Interlingua'
'LANG_id'       'Indonesian'
'LANG_ie'       'Interlingue'
'LANG_it'       'Italian'
'LANG_ja'       'Japanese'
'LANG_jv'       'Javanese'
'LANG_km'       'Cambodian'
'LANG_ko'       'Korean'
'LANG_la'       'Latin'
'LANG_lt'       'Lithuanian'
'LANG_lv'       'Lettish'
'LANG_mk'       'Macedonian'
'LANG_mo'       'Moldavian'
'LANG_mn'       'Mongolian'
'LANG_my'       'Burmese'
'LANG_nl'       'Dutch'
'LANG_no'       'Norwegian'
'LANG_pl'       'Polish'
'LANG_pt'       'Portuguese'
'LANG_pt_br'    'Portuguese (Brazilian)'
'LANG_rm'       'Rhaeto-Romance'
'LANG_ro'       'Romanian'
'LANG_ru'       'Russian'
'LANG_sa'       'Sanskrit'
'LANG_sh'       'Serbo-Croatian'
'LANG_sk'       'Slovak'
'LANG_sl'       'Slovenian'
'LANG_sr'       'Serbian'
'LANG_sv'       'Swedish'
'LANG_sw'       'Swahili'
'LANG_th'       'Thai'
'LANG_tk'       'Turkmen'
'LANG_tr'       'Turkish'
'LANG_uk'       'Ukrainian'
'LANG_vi'       'Vietnamese'
'LANG_yi'       'Yiddish'
'LANG_zh'       'Chinese (simplified)'
'LANG_zh_trad'  'Chinese (traditional)'
'LANG_zu'       'Zulu'

#if Language == #af                 "afrikaans"
; 'Afrikaans'        'Afrikaans'
'Arabic'           'Arabies'
'Chinese'          'Sjinees'
'Chinese (simplified)'          'Sjinees (simplified)'
'Chinese (traditional)'         'Sjinees (traditional)'
'Czech'            'Tsjeggies'
'Croatian'          'Kroaties'    "/ ???
'Danish'           'Deens'
'German'           'Duits'
'Greek'            'Grieks'
'English (US)'     'Engels (US)'
'English (UK)'     'Engels (UK)'
; 'Esperanto'        'Esperanto'
'Spanish'          'Spaans'
'Italian'          'Italiaans'
'French'           'Fins'
'Japanese'         'Japannees'
'Dutch'            'Nederlands'
'Norwegian'        'Noors'
'Polish'           'Pools'
'Portuguese'       'Portugees'
'Russian'          'Russies'
'Slovak'           'Slowaaks'
'Swedish'          'Zweeds'
'Turkish'          'Turks'
#endif

#if Language == #bs                 "bosnian"
PREFERRED_FONT_ENCODINGS            #('unicode' 'iso8859-2')
# include 'bs.rs'
#endif

#if Language == #ca                 "catalan"
PREFERRED_FONT_ENCODINGS            #('unicode' 'iso8859-2')
# include 'ca.rs'
#endif

#if Language == #cs                 "czech"
'Afrikaans'                 'Afrikánština'
'Chinese'                   'Čínština'
'Chinese (simplified)'      'Čínština (simplified)'
'Chinese (traditional)'     'Čínština (traditional)'
'Croatian'                  'Chorvatština'
'Czech'                     'Čeština'
'Danish'                    'Dánština'
'Dutch'                     'Nizozemština'
'English (US)'              'Angličtina (US)'
'English (UK)'              'Angličtina (UK)'
'Finnish'                   'Finština'
'German'                    'Němčina'
'Greek'                     'Řečtina'
'Italian'                   'Italština'
'Hindi'                     'Hindština'
'Japanese'                  'Japonština'
'Korean'                    'Korejština'
'Norwegian'                 'Norský'
'Portuguese (Brazilian)'    'Portugalština (brazilská)'
'Portuguese'                'Portugalština'
'Polish'                    'Polština'
'Russian'                   'Ruština'
'Slovak'                    'Slovenština'
'Spanish'                   'Španělština'
'Swedish'                   'Švédština'
'Turkish'                   'Turecky'
#endif

#if Language == #da                 "danish"
; 'Afrikaans'         'Afrikaans'
'Arabic'            'Arabisk'
'Chinese'           'Kinesisk'
'Chinese (simplified)'          'Kinesisk (simplified)'
'Chinese (traditional)'         'Kinesisk (traditional)'
'Croatian'          'Kroatisk'
'Czech'             'Tjekkisk'
'Danish'            'Dansk'
'Dutch'             'Hollandsk'
; 'Esperanto'             'Esperanto'
'English (US)'      'Engelsk (US)'
'English (UK)'      'Engelsk (UK)'
'Finnish'           'Finsk'
'French'            'Fransk'
'German'            'Tysk'
'Greek'             'Græsk'
; 'Hindi'             'Hindi'
'Italian'           'Italiensk'
'Japanese'          'Japansk'
'Norwegian'         'Norsk'
'Korean'            'Koreansk'
'Turkish'           'Tyrkisk'
'Polish'            'Polsk'
'Russian'           'Russisk'
'Spanish'           'Spansk'
'Slovak'            'Slovakisk'
'Swedish'           'Svensk'
'Portuguese (Brazilian)'    'Portugisisk (brasiliansk)'
'Portuguese'                'Portugisisk'
#endif

#if Language == #de                 "german"
; 'Afrikaans'         'Afrikaans'
'Arabic'            'Arabisch'
'Chinese'           'Chinesisch'
'Chinese (simplified)'          'Chinesisch (simplified)'
'Chinese (traditional)'         'Chinesisch (traditional)'
'Croatian'          'Kroatisch'
'Czech'             'Tschechisch'
'Danish'            'Dänisch'
'Dutch'             'Niederländisch'
'English (US)'      'Englisch (US)'
'English (UK)'      'Englisch (UK)'
; 'Esperanto'         'Esperanto'
'German'            'Deutsch'
'Greek'             'Griechisch'
; 'Hindi'             'Hindi'
'Finnish'           'Finnisch'
'French'            'Französisch'
'Italian'           'Italienisch'
'Japanese'          'Japanisch'
'Korean'            'Koreanisch'
'Latin'             'Lateinisch'
'Norwegian'         'Norwegisch'
'Polish'            'Polnisch'
'Portuguese'                'Portugiesisch'
'Portuguese (Brazilian)'    'Portugiesisch (brasilianisch)'
'Russian'           'Russisch'
'Spanish'           'Spanisch'
'Swedish'           'Schwedisch'
'Slovak'            'Slowakisch'
'Slovenian'         'Slowenisch'
'Swahili'           'Suaheli'
'Thai'              'Thai'
'Turkish'           'Türkisch'
'Ukrainian'         'Ukrainisch'
#endif

#if Language == #el                 "greek"
; 'afrikaans'         'afrikaans'
'arabic'            'αραβικά'
'chinese'           'σινικόσ'
'Chinese (simplified)'          'σινικόσ (simplified)'
'Chinese (traditional)'         'σινικόσ (traditional)'
'croatian'          'κροατικά'
; 'czech'             'czech'
'danish'            'δανέζικα'
'dutch'             'ολλανδικά'
'english (US)'      'αγγλικά (US)'
'english (UK)'      'αγγλικά (UK)'
'esperanto'         'εσπεράντο'
'finnish'           'φινλανδός'
'french'            'γαλλικά'
'german'            'γερμανικά'
'greek'             'ελληνικά'
'italian'           'ιταλικά'
'japanese'          'ιαπωνικά'
'latin'             'λατινικά'
'norwegian'         'nορβηγικά'
'polish'            'πολωνικά'
'portuguese'        'πορτογαλικά'
'portuguese (Brazilian)'    'πορτογαλικά (βραζιλίας)'
'russian'           'ρωσικά'
'spanish'           'ισπανός'
'swedish'           'σουηδικά'
'turkish'           'τουρκικά'
#endif


#if Language == #eo                 "esperanto"
'Afrikaans'         'Afrikansa'
'Arabic'            'Araba'
'Chinese'           'Cina'
'Chinese (simplified)'          'Cina (simplified)'
'Chinese (traditional)'         'Cina (traditional)'
'Croatian'          'Kroata'
; 'Czech'             'Czech'
'Danish'            'Danska'
'Dutch'             'Nederlanda'
'English (US)'      'Angla (US)'
'English (UK)'      'Angla (UK)'
; 'Esperanto'         'Esperanto'
'Finnish'           'Finna'
'French'            'Franca'
'German'            'Germana'
'Greek'             'Greka'
'Italian'           'Itala'
'Latin'             'Latina'
'Japanese'          'Japana'
'Norwegian'         'Norvega'
'Portuguese'        'Portugala'
'Portuguese (Brazilian)'    'Portugala (brazila)'
'Russian'           'Rusa'
'Spanish'           'Hispana'
'Swedish'           'Sveda'
'Turkish'           'Turka'
#endif

#if Language == #es                 "spanish"
'Arabic'                        'Árabe'
'Chinese'                       'Chino'
'Chinese (simplified)'          'Chino (simplified)'
'Chinese (traditional)'         'Chino (traditional)'
'Croatian' 'Croata'
'Czech'  'Checo'
'Danish'   'Danés'
'Dutch'   'Holandés'
'English (UK)'   'Inglés (UK)'
'English (US)'   'Inglés (US)'
'Finnish'  'Finlandés'
'French'  'Francés'
'German'  'Alemán'
'Greek'  'Griego'
'Italian'  'Italiano'
'Japanese'  'Japonés'
'Latin' 'Latín'
'Norwegian'     'Noruego'
'Portuguese'    'Portugués'
'Portuguese (Brazilian)'   'Portugués (Brasilero)'
'Russian'    'Ruso'
'Slovak'    'Eslovaco'
'Slovenian'  'Esloveno'
'Spanish'   'Español'
'Swahili'  'Suajelí'
'Swedish'  'Sueco'
'Turkish'  'Turco'
'Ukrainian'  'Ucraniano'
'Norwegian'  'Noruego'
#endif

#if Language == #et                 "estonian"
PREFERRED_FONT_ENCODINGS            #('unicode' 'iso8859-1')
# include 'et.rs'
#endif

#if Language == #fi                 "finnish"
; 'Afrikaans'         'Afrikaans'
'Arabic'            'Arabia'
; 'Chinese'
'Croatian'          'Kroatia'
'Czech'             'Tsekki'
'Danish'            'Tanska'
'Dutch'             'Hollanti'
'English (US)'      'Englanti (US)'
'English (UK)'      'Englanti (UK)'
; 'Esperanto'         'Esperanto'
'Finnish'           'Suomi'
'French'            'Ranska'
'German'            'Saksa'
; 'Greek'             'Griego'
; 'Hindi'
'Italian'           'Italia'
; 'Japanese'
'Latin'             'Latina'
'Norwegian'         'Norjan Kieli'
'Portuguese'        'Portugali'
'Portuguese (Brazilian)'    'Portugali (brazilian)'
'Russian'           'Venäjä'
'Spanish'           'Espanja'
'Swedish'           'Ruotsi'
'Turkish'           'Turkki'
#endif

#if Language == #fr                 "french"
; 'Afrikaans'         'Afrikaans'
'Arabic'            'Arabe'
'Chinese'           'Chinois'
'Chinese (simplified)'          'Chinois (simpl.)'
'Chinese (traditional)'         'Chinois (trad.)'
'Croatian'          'Croate'
'Czech'             'Tchèque'
'Danish'            'Danois'
'Dutch'             'Néerlandais'
'English (US)'      'Anglais (US)'
'English (UK)'      'Anglais (UK)'
; 'Esperanto'         'Esperanto'
'Finnish'           'Finnois'
'French'            'Français'
'German'            'Allemand'
'Greek'             'Grec'
; 'Hindi'            'Hindi'
'Hungarian'         'Hongroise'
'Italian'           'Italien'
'Japanese'          'Japonais'
'Latin'             'Latin'
'Norwegian'         'Norvégien'
'Portuguese'                'Portugais'
'Portuguese (Brazilian)'    'Portugais (brésilien)'
'Russian'           'Russe'
'Spanish'           'Espagnol'
'Slovak'            'Slovaque'
'Swedish'           'Suédois'
'Thai'              'Thaï'
'Turkish'           'Turc'
#endif

#if Language == #hr                 "croatian"
;'Afrikaans'
;'Chinese'
'Croatian'                  'Hrvatski'
;'Czech'
;'Danish'
;'Dutch'
;'English (US)'
;'English (UK)'
;'Finnish'
;'German'
;'Greek'
;'Italian'
;'Japanese'
;'Korean'
'Latin'                     'Latinski'
;'Norwegian'
;'Portuguese (Brazilian)'
;'Portuguese'
;'Polish'
;'Russian'
;'Slovak'
;'Spanish'
;'Swedish'
;'Turkish'
#endif

#if Language == #hu                 "hungarian"
;'Afrikaans'
'Chinese'                       'Kínai'
'Chinese, Simplified'           'Kínai (egyszerűsített)'
'Chinese, Traditional'          'Kínai (hagyományos)'
'Chinese (simplified)'          'Kínai (egyszerűsített)'
'Chinese (traditional)'         'Kínai (hagyományos)'
'Croatian'                      'Horvát'
;'Czech'
'Danish'                        'Dán'
'Dutch'                         'Holland'
'English'                       'Angol'
'English (US)'                  'Angol (US)'
'English (UK)'                  'Angol (UK)'
'Esperanto'                     'Eszperantó'
'French'                        'Francia'
'Finnish'                       'Finn'
'German'                        'Német'
'Greek'                         'Görög'
'Hungarian'                     'Magyar'
'Italian'                       'Olasz'
'Japanese'                      'Japán'
'Korean'                        'Koreai'
;'Latin'
'Norwegian'                     'Norvég'
'Portuguese'                    'Portugál'
'Portuguese (Brazilian)'        'Portugál (BR)'
'Polish'                        'Lengyel'
'Romanian'                      'Román'
'Russian'                       'Orosz'
'Slovak'                        'Szlovák'
'Slovenian'                     'Szlovén'
'Spanish'                       'Spanyol'
;'Swedish'
'Turkish'                       'Török'
#endif

#if Language == #it                 "italian"
; 'Afrikaans'         'Afrikaans'
'Arabic'            'Arabo'
'Chinese'           'Cinese'
'Chinese (simplified)'                 'Cinese (simplified)'
'Chinese (traditional)'                'Cinese (traditional)'
'Croatian'          'Croato'
'Czech'             'Cèco'
'Danish'            'Danese'
'Dutch'             'Olandese'
'English (US)'      'Inglese (US)'
'English (UK)'      'Inglese (UK)'
; 'Esperanto'         'Esperanto'
'Finnish'           'Finlandese'
'French'            'Francese'
'German'            'Tedesco'
'Greek'             'Greco'
'Italian'           'Italiano'
'Latin'             'Latino'
'Japanese'          'Giapponese'
'Norwegian'         'Norvegese'
'Polish'            'Polacco'
'Portuguese'        'Portoghese'
'Portuguese (Brazilian)'    'Portoghese (brasiliano)'
'Russian'           'Russo'
'Spanish'           'Spagnolo'
'Swedish'           'Svedese'
'Turkish'           'Turco'
#endif

#if Language == #ja                 "japanese"
; 'Afrikaans'
'Arabic'                    'アラビア語'
'Chinese'                   '中国語'
'Chinese (simplified)'                 '中国語 (simplified)'
'Chinese (traditional)'                '中国語 (traditional)'
; 'Croatian'
'Czech'                     'チェコ'
; 'Danish'
'German'                    'ドイツ語'
'Greek'                     'ギリシャ'
'English (US)'              '英語 (US)'
'English (UK)'              '英語 (UK)'
'Esperanto'                 'エスペラント語'
'Spanish'                   'スペイン語'
; 'Finnish'
'French'                    'フランスの'
'Italian'                   'イタリア語'
'Japanese'                  '日本語'
'Latin'                     'ラテン語'
; 'Hindi'
'Dutch'                     'オランダ語'
; 'Norwegian'
'Polish'                    'ポーランド語'
'Portuguese'                'ポルトガル語'
'Portuguese (Brazilian)'    'ポルトガル語 (ブラジル)'
'Russian'                   'ロシア語'
; 'Swedish'
'Thai'                      'タイ語'
'Turkish'                   'トルコ語'
; 'Ukrainian'
#endif

#if Language == #ko                 "korean"
'Chinese'           '중국어'
; 'Croatian'
'Esperanto'         '에스페란토'
'French'            '프랑스의'
'German'            '독일말'
'Italian'           '이탈리아말'
'Japanese'          '일본말'
'Korean'            '한국어'
'Spanish'           '스페인 말'
'Thai'              '타이말'
#endif

#if Language == #la                 "latin"
'Afrikaans'                     'Africanus'
; 'Arabic'
; 'Chinese'
'Croatian'                      'Croatica'
'Czech'                         'Ceca'
'Danish'                        'Dana'
; 'Dutch'
'English (US)'                  'Britannica (US)'
'English (UK)'                  'Britannica (UK)'
'Esperanto'                     'Esperantica'
'Finnish'                       'Finnica'
; 'French'
'German'                        'Germanica'
'Greek'                         'Graeca'
'Hindi'                         'Indica'
'Italian'                       'Italica'
; 'Japanese'
; 'Norwegian'
'Latin'                         'Latina'
'Polish'                        'Polona'
'Portuguese'                    'Lusitana'
'Portuguese (Brazialian)'       'Lusitana (Brasiliana)'
'Russian'                       'Russa'
'Spanish'                       'Hiberica'
; 'Slovak'
; 'Swedish'
; 'Turkish'
#endif

#if Language == #nl                 "dutch"
; 'Afrikaans'         'Afrikaans'
; 'Arabic'            'Arabies'     "/ ???
'Chinese'            'Chinees'
'Chinese (simplified)'                 'Chinees (simplified)'
'Chinese (traditional)'                'Chinees (traditional)'
; 'Croatian'          'Kroaties'    "/ ???
; 'Czech'             'Tsjechisch'  "/ ???
'Danish'            'Deens'
'Dutch'             'Nederlands'
'English (US)'      'Engels (US)'
'English (UK)'      'Engels (UK)'
; 'Esperanto'         'Esperanto'
'Finnish'           'Fins'
; 'French'
'German'            'Duits'
'Greek'             'Grieks'
'Hindi'             'Hindoestaans'
'Italian'           'Italiaans'
'Japanese'          'Japans'
'Norwegian'         'Noors'
'Polish'            'Pools'
'Portuguese'        'Portugees'
; 'Russian'
'Spanish'           'Spaans'
'Slovak'            'Slovaaks'
'Swedish'           'Zweeds'
'Turkish'           'Turks'
#endif

#if Language == #no                 "norwegian"
; 'Afrikaans'         'Afrikaans'
; 'Arabic'            'Arabisch'
'Chinese'            'Kinesisk'
'Chinese (simplified)'                 'Kinesisk (simplified)'
'Chinese (traditional)'                'Kinesisk (traditional)'
'Croatian'          'Kroatisk'
; 'Czech'             'Czech'
'Danish'            'Dansk'
'German'            'Tysk'
; 'Greek'             'Greek'
; 'English (US)'      'English (US)'
; 'English (UK)'      'English (UK)'
; 'Esperanto'         'Esperanto'
'Spanish'           'Spansk'
; 'Finnish'           'Finnish'
'French'            'Fransk'
'Italian'           'Italiensk'
; 'Japanese'          'Japanese'
'Dutch'             'Nederlandsk'
'Norwegian'         'Norsk'
; 'Portuguese'        'Portuguese'
; 'Russian'           'Russian'
'Swedish'           'Svensk'
'Turkish'           'Tyrkisk'
#endif

#if Language == #pl                 "polish"
Afrikaans       'Afrykanerski'
Chinese         'Chiński'
'Chinese (simplified)'                 'Chiński (simplified)'
'Chinese (traditional)'                'Chiński (traditional)'
Croatian        'Chorwacki'
Czech           'Czeski'
Dutch           'Niderlandzki'
Danish          'Duński'
'English (US)'  'Angielski (US)'
'English (UK)'  'Angielski (UK)'
Finnish         'Fiński'
French          'Francuski'
German          'Niemiecki'
Greek           'Grecki'
Italian         'Włoski'
Japanese        'Japoński'
Norwegian       'Norweski'
Polish          'Polski'
Portuguese                  'Portugalski'
'Portuguese (Brazilian)'    'Portugalski (brazylii)'
Russian         'Rosyjski'
Spanish         'Hiszpański'
Slovak          'Słowacki'
Swedish         'Szwedzki'
Turkish         'Turecki'
#endif

#if Language == #pt                 "portuguese"
'Afrikaans'         'Africano'
'Arabic'            'Arabe'
'Chinese'           'Chinês'
'Chinese (simplified)'                 'Chinês (simplified)'
'Chinese (traditional)'                'Chinês (traditional)'
'Croatian'          'Croata'
'Czech'             'Tcheco'
'Danish'            'Deens'
'Dutch'             'Holandês'
'English (US)'      'Inglês (US)'
'English (UK)'      'Inglês (UK)'
; 'Esperanto'         'Esperanto'
'Finnish'           'Finlandês'
'French'            'Francês'
'German'            'Alemão'
'Greek'             'Grego'
'Italian'           'Italiano'
'Japanese'          'Japonês'
'Korean'            'Coreano'
'Norwegian'         'Norueguês'
'Polish'            'Polaco'
'Portuguese'        'Português'
'Portuguese (Brazilian)'    'Português (brasileiro)'
'Russian'           'Russo'
'Slovak'            'Eslovaco'
'Spanish'           'Espanhol'
'Swedish'           'Sueco'
'Turkish'           'Turco'

# if LanguageTerritory == #br         "brasilian portuguese"
'Czech'             'Checo'
'Polish'            'Polonês'
# endif

#endif

#if Language == #ro                 "romania"
; Afrikaans               'Afrikaans'
Arabic                  'Arabă'
Chinese                 'Chineză'
'Chinese (simplified)'                 'Chineză (simplified)'
'Chinese (traditional)'                'Chineză (traditional)'
Croatian                'Croată'
Czech                   'Cehă'
Danish                  'Daneză'
Dutch                   'Olandeză'
'English (US)'          'Engleză (US)'
'English (UK)'          'Engleză (UK)'
; Esperanto               'Esperanto'
German                  'Germană'
Greek                   'Greacă'
; Italian
Finnish                 'Finlandeză'
Japanese                'Japoneză'
'Korean'                'Coreeană'
Polish                  'Poloneză'
Portuguese              'Portugheză'
Russian                 'Rusă'
Spanish                 'Spaniolă'
Swedish                 'Suedeză'
Romanian
Thai                    'Tailandeză'
Turkish                 'Turcă'
Ukrainian               'Ucraineană'
#endif

#if Language == #ru                 "russian"
'Afrikaans'         'Африкаанс'
'Arabic'            'Арабский'   "/ ' язык' ???
'Chinese'           'китайский'
'Chinese (simplified)'           'китайский (simplified)'
'Chinese (traditional)'          'китайский (traditional)'
'Croatian'          'хорватский'
'Czech'             'Чешский'
'Danish'            'Датский'
'German'            'Немецкий'
'Greek'             'Греческий'
'Esperanto'         'Эсперанто'
'English (US)'      'Английский (US)'
'English (UK)'      'Английский (OK)'
'Spanish'           'Испанский'
'Finnish'           'Финский'
'French'            'Французский'
'Italian'           'Итальянский'
'Japanese'          'Японский'
'Dutch'             'Голландский'
'Norwegian'         'Норвежский'
'Portuguese'        'Португальский'
'Russian'           'Русский'
'Swedish'           'Шведский'
'Thai'              'тайский'
'Turkish'           'Турецкий'
; 'Ukrainian'
#endif

#if Language == #sl                 "slovenian"
#endif

#if Language == #sk                 "slovak"
; 'Afrikaans'             'Afrikaans'
'Arabic'                'Arabèina'
'Croatian'              'Chorvátsky'
'czech'                 'český'
; 'Danish'
'german'                'nemecký'
'Greek'                 'grécky'
'English (US)'          'anglický (US)'
'English (UK)'          'anglický (UK)'
; 'Esperanto'
'spanish'               'španielsky'
; 'Finnish'
french'                 'francúzsky'
'Italian'               'taliansky'
'Japanese'              'japonský'
; 'Dutch'
; 'Norwegian'
; 'Portuguese'
'russian'               'ruský'
'swedish'               'švédsky'
; 'Turkish'
'slovak'                'slovenský'
#endif

#if Language == #sv                 "swedish"
; 'Afrikaans'         'Afrikaans'
'Arabic'            'Arabiska'
'Chinese'           'Kinesiska'
'Chinese (simplified)'           'Kinesiska (simplified)'
'Chinese (traditional)'          'Kinesiska (traditional)'
'Croatian'          'Kroat'
'Czech'             'Tjeckiska'
'Danish'            'Danska'
'Dutch'             'Holländare'
'English (US)'      'Engelska (US)'
'English (UK)'      'Engelska (UK)'
; 'Esperanto'         'Esperanto'
'Finnish'           'Finska'
'French'            'Fransk'
'German'            'Tyska'
'Greek'             'Grekiska'
'Italian'           'Italiensk'
'Japanese'          'Japanska'
'Norwegian'         'Norska'
'Polish'            'Polska'
'Portuguese'        'Portugisiska'
'Portuguese (Brazilian)'    'Portugisiska (brasiliansk)'
'Russian'           'Russo'
'Slovak'            'Slovakiska'
'Spanish'           'Spansk'
'Swedish'           'Svenska'
'Turkish'           'Turkisk'
#endif

#if Language == #th                 "thai"
'Afrikaans'             'อัฟริกาน'
'Arabic'                'ภาษาอาหรับ'
'Chinese'               'ภาษาจีน'
'Chinese (simplified)'               'ภาษาจีน (simplified)'
'Chinese (traditional)'              'ภาษาจีน (traditional)'
'Croatian'              'ภาษาโครเอเชียน'
'Czech'                 'ภาษาเซ็คโกฯ'
'Danish'                'ภาษาเดนมาร์ก'
'Dutch'                 'ภาษาฮอลันดา'
; 'English (US)'          'English (US)'
; 'English (UK)'          'English (UK)'
'Esperanto'             'ภาษากลาง'
'Finnish'               'ภาษาฟินนิช'
; 'French'                 'French'
'German'                'ภาษาเยอรมัน'
'Greek'                 'ภาษากรีก'
'Italian'               'ภาษาอิตาลี'
'Japanese'              'ภาษาญี่ปุ่น'
'Korean'                'ภาษาเกาหลี'
'Norwegian'             'ภาษานอร์เวย์'
'Polish'                'ภาษาโปแลนด์'
'Portuguese'            'ภาษาโปรตุเกส'
'Russian'               'ภาษารัสเซีย'
; 'Slovenian'               'Slovenian'
'Slovak'                'ภาษาสโลวะเกีย'
'Spanish'               'ภาษาสเปน'
'Swedish'               'ภาษาสวีเดน'
'Thai'                  'ภาษาไทย'
'Turkish'               'ตุรกี'
#endif

#if Language == #tr                 "turkish"
; 'Afrikaans'         'Afrikaans'
'arabic'                'Arap'
'croatian'              'hırvat'
'czech'                 'çek'
'danish'                'danimarkalı'
'Dutch'                 'hollanda'
'English (US)'          'Ingilizce (US)'
'English (UK)'          'Ingilizce (UK)'
; 'Esperanto'         'Esperanto'
; 'Finnish'           'Finnish'
'French'                'Fransiz'
'German'                'Alman'
; 'Greek'             'Greek'
'Italian'               'Italyan'
'Japanese'          'Japanska'
'Norwegian'             'Norveççe'
'Portuguese'            'Portekizce'
'Russian'               'Rusça'
; 'Slovak'                'Slovak'
'Spanish'               'Ispanyol'
'Swedish'               'Isveçli'
'Ukrainian'             'Ukraynali'
'Turkish'               'Türkçe'
#endif

#if Language == #uk                 "ukrainian"
; Afrikaans
Chinese                 'китайська'   "/ 'китайська мова' ???
'Chinese (simplified)'                'китайська (simplified)'   "/ 'китайська мова' ???
'Chinese (traditional)'               'китайська (traditional)'   "/ 'китайська мова' ???
'Croatian'              'хорватський'
Czech                   'чеський'
; Danish
; Dutch
'English (US)'          'англійський (US)'
'English (UK)'          'англійський (UK)'
; Esperanto
German                  'германський'
; Greek
Italian                 'італійський'
; Finnish
Japanese                'японський'
; Polish
; Portuguese
Russian                 'російський'
; Spanish
; Swedish
Turkish                 'турецький'
Ukrainian               'українська'  "/ 'українська мова' ???
#endif

#if Language == #zh                 "chinese"
'Arabic'                            '阿拉伯语'
'Chinese'                           '中文'
'Chinese (simplified)'                '中文 (simplified)'
'Chinese (traditional)'               '中文 (traditional)'
'Croatian'                                                                                                   '克罗地亚语'
'Czech'                                                                                                      '捷克语'
'Danish'                                                                                                     '丹麦语'
'Dutch'                                                                                                       'Dutch'
'English (UK)'                                                                                                '英语(UK)'
'English (US)'                                                                                                '英语(US)'
'Finnish'                                                                                                     'Finnish'
'French'                                                                                                      '法语'
'German'                                                                                                      '德语'
'Greek'                                                                                                       'Greek'
'Italian'                                                                                                     '意大利语'
'Japanese'                                                                                                    '日语'
'Korean'                                                                                                      'Korean'
'Latin'                                                                                                       'Latin'
'Norwegian'                                                                                                   'Norwegian'
'Polish'                                                                                                      'Polish'
'Portuguese'                                                                                                  'Portuguese'
'Portuguese (Brazilian)'                                                                                      'Portuguese (Brazilian)'
'Russian'                                                                                                     'Russian'
'Slovak'                                                                                                      'Slovak'
'Slovenian'                                                                                                   'Slovenian'
'Spanish'                                                                                                     'Spanish'
'Swahili'                                                                                                     'Swahili'
'Swedish'                                                                                                     'Swedish'
'Thai'                                                                                                        'Thai'
'Turkish'                                                                                                     'Turkish'
'Ukrainian'                                                                                                   'Ukrainian'

# if LanguageTerritory == #trad         "chinese traditional"

Chinese                         '汉语'
'Chinese (simplified)'          '汉语 (simplified)'
'Chinese (traditional)'         '汉语 (traditional)'
# endif
#endif
