package jp.sfjp.armadillo.ui.window;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.text.*;
import java.util.*;
import java.util.List;
import javax.swing.*;
import javax.swing.table.*;
import jp.sfjp.armadillo.*;
import jp.sfjp.armadillo.archive.*;

public final class ListDialog extends JDialog {

    static Logger log = Logger.getLogger(ListDialog.class);
    static ResourceManager res = ResourceManager.getInstance("jp.sfjp.armadillo.ui.messages");

    public ListDialog(final MainWindow mainWindow,
                      final File src,
                      ArchiveType type,
                      ProgressNotifier progressNotifier) throws IOException {
        super(mainWindow);
        setTitle(String.format("%s", src.getAbsolutePath()));
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        List<ArchiveEntry> infos = ArmadilloCommands.extractArchiveEntries(src, type);
        Object[][] rowData = new Object[infos.size()][];
        int i = -1;
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (final ArchiveEntry entry : infos) {
            final Object compsize;
            if (entry.getCompressedSize() >= 0)
                compsize = entry.getCompressedSize();
            else
                compsize = "";
            final Object mtime = df.format(new Date(entry.getLastModified()));
            Object[] row = {entry.getName(), entry.getMethodName(), entry.getSize(), compsize,
                            mtime,};
            rowData[++i] = row;
        }
        Object[] columnNames = {res.get("label.list.name"), res.get("label.list.method"),
                                res.get("label.list.size"), res.get("label.list.compsize"),
                                res.get("label.list.mtime")};
        final JTable t = new JTable(rowData, columnNames);
        t.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        TableColumnModel cm = t.getColumnModel();
        cm.getColumn(0).setPreferredWidth(256);
        cm.getColumn(4).setPreferredWidth(124);
        t.getTableHeader().setResizingAllowed(false);
        JScrollPane sp = new JScrollPane(t,
                                         ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
                                         ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        add(sp, BorderLayout.CENTER);
        JButton button = new JButton(new AbstractAction(res.get("button.extractSelectedEntries")) {
            @Override
            public void actionPerformed(ActionEvent e) {
                Set<String> targetSet = new LinkedHashSet<String>();
                long totalSize = 0L;
                for (final int rowIndex : t.getSelectedRows()) {
                    targetSet.add(String.valueOf(t.getValueAt(rowIndex, 0)));
                    totalSize += toLong(t.getValueAt(rowIndex, 3));
                }
                mainWindow.startExtractAction(src, totalSize, targetSet);
            }
            private long toLong(Object o) {
                if (o == null)
                    return 0;
                final String s = String.valueOf(o).trim();
                if (s.isEmpty())
                    return 0;
                assert s.matches("\\d+");
                return Long.parseLong(s);
            }
        });
        add(button, BorderLayout.NORTH);
        pack();
    }

    void showInfoList(final File archiveFile, List<ArchiveEntry> entryList) {
        setVisible(true);
    }

}
