package jp.sfjp.armadillo.time;

public final class FileTime implements TimeConverter {

    // difference between Java millis and FileTime
    // (369years * 365days * 86400secs * 1000000 + adjustment of leap yaar)
    private static final long DIFFERENCE = 116444736000000000L;

    public FileTime() { // empty
    }

    @Override
    public int int32From(long ms) {
        throw new UnsupportedOperationException("32bit not supported");
    }

    @Override
    public long int64From(long ms) {
        return ms * 10000L + DIFFERENCE;
    }

    @Override
    public long toMilliseconds(long time) {
        return (time - DIFFERENCE) / 10000L;
    }

}
