package jp.sfjp.armadillo.archive.lzh;

import java.util.zip.*;

/**
 * Checksum(CRC16) for LZH.
 */
public final class LzhChecksum implements Checksum {

    private final int[] table;
    private final int initial;

    private int value;

    public LzhChecksum() {
        this(0xA001, 0);
    }

    LzhChecksum(int exp, int initial) {
        this.table = create(exp);
        this.initial = initial;
        this.value = initial;
    }

    /**
     * Creates table.
     * @param exp
     * @return 
     */
    static int[] create(int exp) {
        int[] table = new int[256];
        for (int i = 0; i < table.length; i++) {
            table[i] = i;
            for (int j = 0; j < 8; j++) {
                if ((table[i] & 0x01) != 0) {
                    table[i] = (table[i] >> 1) ^ exp;
                }
                else {
                    table[i] >>= 1;
                }
            }
        }
        return table;
    }

    public short getShortValue() {
        return (short)(value & 0xFFFF);
    }

    @Override
    public long getValue() {
        return value;
    }

    @Override
    public void reset() {
        value = initial;
    }

    @Override
    public void update(int b) {
        int value = this.value;
        value = (value >> 8) ^ table[(value ^ b) & 0xFF];
        this.value = value;
    }

    @Override
    public void update(byte[] bytes, int offset, int length) {
        int value = this.value;
        for (int i = offset; i < offset + length; i++) {
            value = (value >> 8) ^ table[(value ^ bytes[i]) & 0xFF];
        }
        this.value = value;
    }

}
