package jp.sfjp.armadillo.archive.lzh;

import java.io.*;
import jp.sfjp.armadillo.archive.*;
import jp.sfjp.armadillo.io.*;

public final class LzhArchiveExtractor implements ArchiveExtractor {

    private LzhInputStream is;

    public LzhArchiveExtractor(InputStream is) {
        this.is = new LzhInputStream(is);
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        return ArchiveEntry.orNull(is.getNextEntry());
    }

    @Override
    public long extract(OutputStream os) throws IOException {
        return IOUtilities.transferAll(is, os);
    }

    @Override
    public void close() throws IOException {
        is.close();
    }

}
