package jp.sfjp.armadillo.archive.cab;

import java.io.*;
import java.util.*;

public final class CabCfFolder extends CabEntry {

    final List<CabCfFile> files;
    ByteArrayOutputStream bos;
    CabCfData currentCabCfData;
    short method;
    int checksum;
    int offset;
    final List<CabCfData> arrayOfCfData;

    public CabCfFolder() {
        super();
        this.files = new ArrayList<CabCfFile>();
        this.arrayOfCfData = new ArrayList<CabCfData>();
    }

    public CabCfFolder(String name) {
        this();
        if (name == null)
            throw new IllegalArgumentException("name is null");
        setName(name);
        this.bos = new ByteArrayOutputStream();
    }

    public void writeCfDataInto(OutputStream os, CabHeader header) throws IOException {
        for (CabCfData data : arrayOfCfData) {
            header.writeCfDataHeader(os, data);
            data.writeInto(os);
        }
    }

    @Override
    public long getSize() {
        return 0;
    }

    @Override
    public void setSize(long size) {
        // ignore
    }

    @Override
    public long getCompressedSize() {
        return 0;
    }

    @Override
    public void setCompressedSize(long size) {
        // ignore
    }

    @Override
    public void setLastModified(long time) {
        // ignore
    }

    public boolean add(CabCfFile f) {
        return files.add(f);
    }

    public int getCompressedDataSize() {
        int size = 0;
        for (CabCfData data : arrayOfCfData)
            size += data.bos.size();
        return size;
    }

    public void close() throws IOException {
        final int size = bos.size();
        byte[] bytes = bos.toByteArray();
        final int cfDataSize = 32768;
        int len = size;
        final int count;
        if (size == 0)
            count = 0;
        else if (size < cfDataSize)
            count = 1;
        else
            count = size / cfDataSize + 1;
        int p = 0;
        method = 1;
        for (int i = 0; i < count; i++) {
            CabCfData data = new CabCfData(CabCompressionType.of(method));
            try {
                final int writeLen = len > cfDataSize ? cfDataSize : len;
                data.write(bytes, p, writeLen);
                p += cfDataSize;
                len -= cfDataSize;
            }
            finally {
                data.close();
            }
            arrayOfCfData.add(data);
        }
        bos = null;
    }

}
