package jp.sfjp.armadillo.archive.cab;

import java.io.*;
import jp.sfjp.armadillo.time.*;

public final class CabCfFile extends CabEntry {

    private static final FTime FTIME = new FTime();

    CabCfFolder folder = new CabCfFolder("./");
    int uncompressedSize;
    int uncompressedOffset;
    short folderIndex;
    short date;
    short time;
    short attributes;

    public CabCfFile() {
        super();
        this.uncompressedSize = 0;
        this.uncompressedOffset = 0;
        this.folderIndex = 0;
        this.date = 0;
        this.time = 0;
        this.attributes = 0x20;
    }

    public CabCfFile(byte[] name) {
        this();
        setName(name);
    }

    public CabCfFile(String name, File file) {
        this();
        setName(name);
        setSize(file.length());
        setLastModified(file.lastModified());
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long getSize() {
        return uncompressedSize;
    }

    @Override
    public void setSize(long size) {
        if (size > Integer.MAX_VALUE)
            throw new IllegalArgumentException("limit=int_max, size=" + size);
        this.uncompressedSize = (int)(size & 0xFFFFFFFF);
    }

    @Override
    public long getCompressedSize() {
        return -1L;
    }

    @Override
    public void setCompressedSize(long size) {
        // ignore
    }

    @Override
    public long getLastModified() {
        return FTIME.toMillisecond(date, time);
    }

    @Override
    public void setLastModified(long lastModified) {
        final int datetime = FTIME.int32From(lastModified);
        this.date = (short)((datetime >> 16) & 0xFFFF);
        this.time = (short)(datetime & 0xFFFF);
    }

    @Override
    public String getMethodName() {
        return CabCompressionType.of(folder.method).toString();
    }

}
