package jp.sfjp.armadillo.archive;

public enum ArchiveType {

    TAR, TARZ, TARGZ, TARBZ2, TARXZ, ZIP, LZH, CAB, Unknown;

    public static ArchiveType of(String fileName) {
        final String ext = getExtension(fileName);
        if (ext.equalsIgnoreCase("tar"))
            return TAR;
        if (ext.equalsIgnoreCase("zip") || ext.equalsIgnoreCase("jar"))
            return ZIP;
        if (ext.equalsIgnoreCase("lzh"))
            return LZH;
        if (ext.equalsIgnoreCase("cab"))
            return CAB;
        if (endsWithIgnoreCase(fileName, ".tar.z", ".tz", ".taz"))
            return TARZ;
        if (endsWithIgnoreCase(fileName, ".tar.gz", ".tgz"))
            return TARGZ;
        if (endsWithIgnoreCase(fileName, ".tar.bz2", ".tbz"))
            return TARBZ2;
        if (endsWithIgnoreCase(fileName, ".tar.xz", ".txz"))
            return TARXZ;
        return Unknown;
    }

    static boolean endsWithIgnoreCase(String s, String... suffixes) {
        for (final String suffix : suffixes) {
            final int sl = s.length();
            final int suffixl = suffix.length();
            if (sl >= suffixl && s.substring(sl - suffixl).equalsIgnoreCase(suffix))
                return true;
        }
        return false;
    }

    static String getExtension(String fileName) {
        final int index = fileName.lastIndexOf('.');
        if (index < 0)
            return "";
        return fileName.substring(index + 1).toLowerCase();
    }

}
