package jp.sfjp.armadillo.archive;

import java.io.*;

/**
 * The OutputStream for Archive.
 */
public abstract class ArchiveOutputStream extends FilterOutputStream {

    protected OutputStream frontStream;
    protected long written;

    private boolean closed;

    public ArchiveOutputStream(OutputStream out) {
        super(out);
    }

    protected final void ensureOpen() throws IOException {
        if (closed)
            throw new IOException("stream closed");
    }

    @Override
    public void write(int b) throws IOException {
        ensureOpen();
        if (frontStream == null)
            super.write(b);
        else
            frontStream.write(b);
        ++written;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ensureOpen();
        if (frontStream == null)
            super.write(b, off, len);
        else
            frontStream.write(b, off, len);
        written += len;
    }

    @Override
    public void flush() throws IOException {
        ensureOpen();
        if (frontStream == null)
            super.flush();
        else
            frontStream.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            flush();
        }
        finally {
            closed = true;
            frontStream = null;
            super.close();
        }
    }

}
