/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.ui.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import jp.sfjp.armadillo.ArmadilloCommands;
import jp.sfjp.armadillo.Logger;
import jp.sfjp.armadillo.ProgressNotifier;
import jp.sfjp.armadillo.ResourceManager;
import jp.sfjp.armadillo.archive.ArchiveType;
import jp.sfjp.armadillo.ui.window.ListDialog;

public final class MainWindow
extends JFrame {
    static Logger log = Logger.getLogger(MainWindow.class);
    static ResourceManager res = ResourceManager.getInstance("jp.sfjp.armadillo.ui.messages");
    static Color doneBGC = Color.decode("#99ff99");
    private final Executor executor;
    private final Box box;
    private final JComboBox archiveTypeCombo;
    private final JCheckBox listMode;

    public MainWindow() {
        this.setTitle(MainWindow.getTitleString());
        this.setDefaultCloseOperation(3);
        this.executor = Executors.newCachedThreadPool();
        this.box = Box.createVerticalBox();
        this.archiveTypeCombo = new JComboBox<Object>(MainWindow.getArchiveExtensions());
        this.listMode = new JCheckBox();
        this.setDropTarget(new DropTarget(this, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list;
                    dropTargetDropEvent.acceptDrop(3);
                    try {
                        List list2 = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        list = list2;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw (RuntimeException)exception;
                        }
                        throw new RuntimeException(exception);
                    }
                    for (File file : list) {
                        MainWindow.this.startAction(file);
                    }
                }
            }
        }));
        JScrollPane jScrollPane = new JScrollPane(this.box, 22, 32);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JButton(new AbstractAction(res.get("button.closeFinishedProgressPanel", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.clearFinishedProgressPanel();
            }
        }));
        jPanel.add(new JLabel("    "));
        jPanel.add(new JLabel(res.get("label.extensionToCreateArchive", new Object[0])));
        jPanel.add(this.archiveTypeCombo);
        jPanel.add(new JLabel("    "));
        jPanel.add(new JLabel(res.get("label.listMode", new Object[0])));
        jPanel.add(this.listMode);
        this.archiveTypeCombo.setPreferredSize(new Dimension(60, 20));
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
    }

    static String getTitleString() {
        return res.get(".title", ArmadilloCommands.getVersionString());
    }

    static Object[] getArchiveExtensions() {
        String[] stringArray = res.get("extensionsToCreateArchive", new Object[0]).split(",", -1);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add("." + string);
        }
        return arrayList.toArray();
    }

    void createArchive(File file, File file2, ProgressNotifier progressNotifier) throws IOException {
        log.setEnteredMethodName("createArchive");
        log.debug("start to create archive %s into %s", (Object)file2, (Object)file);
        ArmadilloCommands.createArchive(file, file2, progressNotifier);
        log.trace("done");
        log.atExit();
    }

    void showInfoListWindow(File file, ProgressNotifier progressNotifier) throws IOException {
        log.setEnteredMethodName("showInfoListWindow");
        log.debug("start to show list of archive %s", (Object)file);
        ArchiveType archiveType = ArchiveType.of(file.getName());
        ListDialog listDialog = new ListDialog(this, file, archiveType, progressNotifier);
        listDialog.setSize(600, 400);
        listDialog.setModal(false);
        listDialog.setVisible(true);
        log.trace("done");
        log.atExit();
    }

    void extractArchive(File file, File file2, ProgressNotifier progressNotifier) throws IOException {
        log.setEnteredMethodName("extractArchive");
        log.debug("start to extract all files from archive %s into %s", (Object)file, (Object)file2);
        ArmadilloCommands.extractAll(file, file2, progressNotifier);
        log.trace("done");
        log.atExit();
    }

    void extractArchive(File file, File file2, Set<String> set, ProgressNotifier progressNotifier) throws IOException {
        log.setEnteredMethodName("extractArchive(+targets)");
        log.debug("start to extract %d files from archive %s into %s", set.size(), file, file2);
        ArmadilloCommands.extract(file, file2, set, progressNotifier);
        log.trace("done");
        log.atExit();
    }

    ActionMode detectMode(File file) {
        if (this.listMode.isSelected()) {
            if (file.isDirectory()) {
                return ActionMode.Unknown;
            }
            return ActionMode.List;
        }
        if (file.isDirectory()) {
            return ActionMode.Create;
        }
        if (ArchiveType.of(file.getName()) != ArchiveType.Unknown) {
            return ActionMode.Extract;
        }
        return ActionMode.Unknown;
    }

    void startAction(File ... fileArray) {
        Set<String> set = Collections.emptySet();
        for (File file : fileArray) {
            this.executor.execute(new ActionWorker(file, this.detectMode(file), set, file.length()));
        }
    }

    void startExtractAction(File file, long l, Set<String> set) {
        this.executor.execute(new ActionWorker(file, ActionMode.Extract, set, l));
    }

    String getSelectedArchiveType() {
        return String.valueOf(this.archiveTypeCombo.getSelectedItem());
    }

    void clearFinishedProgressPanel() {
        final Box box = this.box;
        for (Component component : box.getComponents()) {
            ProgressInfoPanel progressInfoPanel;
            if (!(component instanceof ProgressInfoPanel) || !(progressInfoPanel = (ProgressInfoPanel)component).isFinished()) continue;
            box.remove(component);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JComponent)box.getParent()).updateUI();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProgressInfoPanel addProgressInfoPanel(File file, File file2, ActionMode actionMode, Set<String> set) {
        ProgressInfoPanel progressInfoPanel = new ProgressInfoPanel(this.box, actionMode, file, file2, set);
        Box box = this.box;
        synchronized (box) {
            progressInfoPanel.setMaximumSize(new Dimension(32768, progressInfoPanel.getPreferredSize().height));
            this.box.add(progressInfoPanel);
            this.box.revalidate();
            return progressInfoPanel;
        }
    }

    public static void main(final String[] stringArray) {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                log.fatal(throwable, "at thread %s", thread);
                throwable.printStackTrace();
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                this.setLaF();
                MainWindow mainWindow = new MainWindow();
                mainWindow.setSize(640, 400);
                mainWindow.setLocationByPlatform(true);
                mainWindow.setVisible(true);
                for (String string : stringArray) {
                    mainWindow.startAction(new File(string));
                }
            }

            void setLaF() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        });
    }

    private final class ProgressInfoPanel
    extends JPanel {
        private final JComponent parent;
        private final JProgressBar pbar;
        private final JLabel lTimeInfo;
        private final JLabel lMessage;
        private final StringBuilder messageBuffer;
        private boolean finished;
        private final long startTime = System.currentTimeMillis();

        ProgressInfoPanel(JComponent jComponent, ActionMode actionMode, File file, File file2, Set<String> set) {
            String string;
            this.parent = jComponent;
            this.pbar = new JProgressBar(0, 1000);
            this.messageBuffer = new StringBuilder();
            this.lTimeInfo = new JLabel();
            this.lTimeInfo.setText(String.format("time: started at %tT", this.startTime));
            this.lMessage = new JLabel();
            this.setLayout(new GridLayout(5, 1));
            this.setMessage("");
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)new JLabel(res.get("mode.caption." + (Object)((Object)actionMode), new Object[0])), "Center");
            this.add((Component)jPanel, "North");
            String string2 = string = actionMode == ActionMode.List ? res.get("word.dialog", new Object[0]) : String.valueOf(file2);
            if (set.isEmpty()) {
                this.add(new JLabel(String.format("%s -> %s", file, string)));
            } else {
                this.add(new JLabel(String.format("%d files in %s -> %s", set.size(), file, string)));
            }
            this.add(this.pbar);
            this.add(this.lTimeInfo);
            this.add(this.lMessage);
        }

        void setMessage(String string) {
            this.messageBuffer.append(string);
            this.lMessage.setText("message: " + this.messageBuffer);
            this.parent.updateUI();
        }

        void setRate(int n) {
            this.pbar.setValue(n);
            this.parent.updateUI();
        }

        void setFinished(boolean bl) {
            this.finished = bl;
            long l = System.currentTimeMillis();
            long l2 = (l - this.startTime) / 1000L;
            this.setMessage(res.get("status.done", new Object[0]));
            this.lTimeInfo.setText(String.format("elapsed: %d secs ( %tT to %tT )", l2, this.startTime, l));
            this.setBackground(doneBGC);
        }

        boolean isFinished() {
            return this.finished;
        }

        ProgressNotifier getProgressNotifier(long l) {
            return new ItsProgressNotifier(l);
        }

        private final class ItsProgressNotifier
        extends ProgressNotifier
        implements Runnable {
            protected ItsProgressNotifier(long l) {
                super(l);
            }

            @Override
            public void progressNotified(long l, long l2) {
                EventQueue.invokeLater(this);
            }

            @Override
            public void run() {
                ProgressInfoPanel.this.setRate(this.getRateAsIntPermill());
                ProgressInfoPanel.this.updateUI();
            }
        }
    }

    static enum ActionMode {
        AutoDetects,
        Create,
        List,
        Extract,
        Unknown;

    }

    private final class ActionWorker
    extends SwingWorker<Integer, Integer> {
        final File file;
        final ActionMode mode;
        final Set<String> targets;
        final long totalSize;
        File dst;
        ProgressInfoPanel infoPanel;
        boolean errorOccurred;
        String errorMessage;

        ActionWorker(File file, ActionMode actionMode, Set<String> set, long l) {
            this.file = file;
            assert (actionMode != ActionMode.AutoDetects);
            this.mode = actionMode;
            this.targets = set;
            this.totalSize = l;
            switch (this.mode) {
                case Create: {
                    String string = MainWindow.this.getSelectedArchiveType();
                    this.dst = new File(file.getParentFile(), file.getName() + string);
                    break;
                }
                case Extract: {
                    this.dst = ArmadilloCommands.getDestinationDirectory(file);
                    break;
                }
            }
            this.infoPanel = MainWindow.this.addProgressInfoPanel(file, this.dst, this.mode, set);
            this.errorOccurred = false;
            this.errorMessage = "(unknown error)";
        }

        @Override
        protected Integer doInBackground() throws Exception {
            block9: {
                log.setEnteredMethodName("ActionWorker#doInBackground");
                try {
                    switch (this.mode == ActionMode.Unknown ? MainWindow.this.detectMode(this.file) : this.mode) {
                        case Create: {
                            long l = ArmadilloCommands.getTotalSize(this.file);
                            MainWindow.this.createArchive(this.file, this.dst, this.createProgressNotifier(l));
                            break;
                        }
                        case List: {
                            MainWindow.this.showInfoListWindow(this.file, this.createProgressNotifier(this.totalSize));
                            break;
                        }
                        case Extract: {
                            if (this.targets.isEmpty()) {
                                MainWindow.this.extractArchive(this.file, this.dst, this.createProgressNotifier(this.totalSize));
                                break;
                            }
                            MainWindow.this.extractArchive(this.file, this.dst, this.targets, this.createProgressNotifier(this.totalSize));
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    log.error(throwable);
                    this.errorOccurred = true;
                    this.errorMessage = String.format("error at %s: %s", this.file, throwable);
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    if (!(throwable instanceof Error)) break block9;
                    throw (Error)throwable;
                }
            }
            return 0;
        }

        private ProgressNotifier createProgressNotifier(long l) {
            return this.infoPanel.getProgressNotifier(l);
        }

        @Override
        protected void done() {
            this.infoPanel.setFinished(true);
            if (this.errorOccurred) {
                this.infoPanel.setMessage(this.errorMessage);
            }
        }
    }
}

