/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.ui.console;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.sfjp.armadillo.ArmadilloCommands;
import jp.sfjp.armadillo.ResourceManager;
import jp.sfjp.armadillo.archive.ArchiveCreator;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.ArchiveExtractor;
import jp.sfjp.armadillo.archive.ArchiveType;

public final class CommandLine {
    static final ResourceManager res = ResourceManager.getInstance("jp.sfjp.armadillo.ui.messages");

    static void usage(int n) {
        switch (n) {
            case 1: {
                System.out.println(res.get("msg.warn-nofunction", new Object[0]));
                break;
            }
        }
        System.out.println(res.get("msg.usage", new Object[0]));
        System.exit(2);
    }

    static void execute(char c, String string, List<String> list) throws IOException {
        switch (c) {
            case 'c': {
                if (list.isEmpty()) {
                    CommandLine.usage(0);
                }
                CommandLine.createArchive(new File(string), list);
                break;
            }
            case 't': {
                if (!list.isEmpty()) {
                    System.out.println(res.get("msg.warn-ignoresecondfile", new Object[0]));
                }
                CommandLine.listArchive(new File(string));
                break;
            }
            case 'x': {
                CommandLine.extractArchive(string, list);
                break;
            }
            case 'z': {
                break;
            }
            case 'd': {
                break;
            }
            case 'v': {
                if (ArmadilloCommands.validate(new File(string))) {
                    System.out.println("OK");
                    break;
                }
                System.out.println("NG");
                break;
            }
            default: {
                throw new IllegalStateException("function=" + c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createArchive(File file, List<String> list) throws IOException {
        ArchiveType archiveType = ArchiveType.of(file.getName());
        ArchiveCreator archiveCreator = ArmadilloCommands.getArchiveCreator(file, archiveType);
        try {
            for (String string : list) {
                if (string.length() == 0) continue;
                File file2 = new File(string);
                String string2 = string.replace('\\', '/');
                if (file2.isDirectory() && !string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                if (file2.isDirectory()) {
                    for (File file3 : ArmadilloCommands.getAllChildrenFile(file2)) {
                        CommandLine.addEntry(archiveCreator, file3, string2);
                    }
                    continue;
                }
                CommandLine.addEntry(archiveCreator, file2, string2);
            }
        }
        finally {
            archiveCreator.close();
        }
    }

    private static ArchiveEntry addEntry(ArchiveCreator archiveCreator, File file, String string) throws IOException {
        ArchiveEntry archiveEntry = archiveCreator.newEntry(string);
        archiveEntry.setSize(file.length());
        archiveEntry.setLastModified(file.lastModified());
        assert (!archiveEntry.isDirectory() || archiveEntry.getSize() == 0L);
        archiveCreator.addEntry(archiveEntry, file);
        return archiveEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void listArchive(File file) throws IOException {
        ArchiveType archiveType = ArchiveType.of(file.getName());
        ArchiveExtractor archiveExtractor = ArmadilloCommands.getArchiveExtractor(file, archiveType);
        try {
            ArchiveEntry archiveEntry;
            while ((archiveEntry = archiveExtractor.nextEntry()) != ArchiveEntry.NULL) {
                String string = archiveEntry.getMethodName();
                System.out.print(string.length() < 8 ? String.format("%-8s", string) : string.substring(0, 8));
                System.out.printf("%9d", archiveEntry.getSize());
                System.out.printf(" %1$tF %1$tT ", new Date(archiveEntry.getLastModified()));
                System.out.println(archiveEntry.getName());
            }
        }
        finally {
            archiveExtractor.close();
        }
    }

    static void extractArchive(String string, List<String> list) throws IOException {
        String string2;
        if (list.isEmpty()) {
            string2 = string + ".tmp";
        } else {
            if (list.size() > 1) {
                System.out.println("msg.warn-ignorethirdfile");
            }
            string2 = list.get(0);
        }
        ArmadilloCommands.extractAll(new File(string), new File(string2));
    }

    public static void main(String[] stringArray) {
        int n = 32;
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.equals("--")) {
                n = 45;
                ++n2;
                continue;
            }
            if (string.startsWith("--")) {
                if (string.equals("--validate")) {
                    n = 118;
                    ++n2;
                    continue;
                }
                if (string.equals("--version")) {
                    System.out.println(res.get(".version", ArmadilloCommands.getVersionString(true)));
                    return;
                }
                CommandLine.usage(0);
                continue;
            }
            if (string.equals("-")) {
                CommandLine.usage(0);
                continue;
            }
            if (string.startsWith("-")) {
                block6: for (int i = 1; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    switch (c) {
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 't': 
                        case 'v': 
                        case 'x': 
                        case 'z': {
                            n = c;
                            ++n2;
                            continue block6;
                        }
                        default: {
                            arrayList.add(String.valueOf(c));
                        }
                    }
                }
                continue;
            }
            if (n2 == 0) {
                CommandLine.usage(1);
                continue;
            }
            arrayList2.add(string);
        }
        if (n2 != 1) {
            CommandLine.usage(1);
        }
        if (arrayList2.isEmpty()) {
            CommandLine.usage(0);
        }
        String string = (String)arrayList2.remove(0);
        try {
            CommandLine.execute((char)n, string, arrayList2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

