/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public final class RewindableInputStream
extends PushbackInputStream {
    private byte[] buffer;
    private int limit;

    public RewindableInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
        this.buffer = new byte[n];
        this.limit = 0;
    }

    public int rewind(int n) throws IOException {
        if (this.limit < n) {
            throw new IOException("length=" + n + ", but limit=" + this.limit);
        }
        int n2 = this.limit - n;
        this.unread(this.buffer, n2, n);
        this.limit = n2;
        return n;
    }

    private void add(byte[] byArray, int n, int n2) {
        if (n2 > this.buffer.length) {
            this.limit = n2;
            this.buffer = new byte[n2];
            System.arraycopy(byArray, 0, this.buffer, 0, n2);
        } else {
            int n3 = this.limit + n2 - this.buffer.length;
            if (n3 > 0) {
                this.limit -= n3;
                System.arraycopy(this.buffer, n3, this.buffer, 0, this.limit);
            }
            System.arraycopy(byArray, n, this.buffer, this.limit, n2);
            this.limit += n2;
        }
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.add(new byte[]{(byte)(n & 0xFF)}, 0, 1);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        assert (n3 != 0) : "Read Zero";
        if (n3 > 0) {
            this.add(byArray, n, n3);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        long l3 = l;
        if (l3 >= (long)this.buffer.length) {
            if (l3 > (long)this.buffer.length) {
                l2 += super.skip(l3 -= (long)this.buffer.length);
            }
            l3 = this.buffer.length;
        }
        assert (l3 <= Integer.MAX_VALUE);
        int n = (int)l3;
        return l2 += (long)this.read(new byte[n]);
    }

    @Override
    public int available() throws IOException {
        return this.buffer.length;
    }
}

