/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public final class InspectionOutputStream
extends FilterOutputStream {
    private long size = 0L;
    private boolean hasChecksum;
    private Checksum checksum;

    public InspectionOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public InspectionOutputStream(OutputStream outputStream, Checksum checksum) {
        this(outputStream);
        this.hasChecksum = checksum != null;
        this.checksum = checksum;
    }

    public void reset() {
        this.size = 0L;
        if (this.hasChecksum) {
            this.checksum.reset();
        }
    }

    public long getSize() {
        return this.size;
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        ++this.size;
        if (this.hasChecksum) {
            this.checksum.update(n);
        }
    }
}

