/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import jp.sfjp.armadillo.archive.zip.ZipEndEntry;
import jp.sfjp.armadillo.archive.zip.ZipEntry;

public final class ZipHeader {
    static final int SIGN_LOC = 67324752;
    static final int SIGN_CEN = 33639248;
    static final int SIGN_END = 101010256;
    static final int SIGN_EXT = 134695760;
    static final int LENGTH_LOC = 30;
    static final int LENGTH_CEN = 46;
    static final int LENGTH_END = 22;
    static final int LENGTH_EXT = 16;
    private final ByteBuffer buffer = ByteBuffer.allocate(46).order(ByteOrder.LITTLE_ENDIAN);
    private final List<ZipEntry> entries = new ArrayList<ZipEntry>();
    private long offset = 0L;

    public ZipEntry read(InputStream inputStream) throws IOException {
        return this.readLOC(inputStream);
    }

    public ZipEntry readLOC(InputStream inputStream) throws IOException {
        this.buffer.clear();
        this.buffer.limit(30);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() == 0) {
            return null;
        }
        this.buffer.rewind();
        int n = this.buffer.getInt();
        if (n == 33639248 || n == 101010256) {
            return null;
        }
        if (n != 67324752) {
            throw new ZipException(String.format("invalid LOC header: signature=0x%X", n));
        }
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        short s3 = this.buffer.getShort();
        short s4 = this.buffer.getShort();
        short s5 = this.buffer.getShort();
        int n2 = this.buffer.getInt();
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        short s6 = this.buffer.getShort();
        short s7 = this.buffer.getShort();
        byte[] byArray = new byte[s6];
        if (inputStream.read(byArray) != s6) {
            throw new ZipException("invalid LOC header (name length)");
        }
        if (s7 > 0 && inputStream.skip(s7) != (long)s7) {
            throw new ZipException("invalid LOC header (extra length)");
        }
        ZipEntry zipEntry = new ZipEntry();
        zipEntry.signature = n;
        zipEntry.version = s;
        zipEntry.flags = s2;
        zipEntry.method = s3;
        zipEntry.mdate = s5;
        zipEntry.mtime = s4;
        zipEntry.crc = n2;
        zipEntry.compsize = n3;
        zipEntry.uncompsize = n4;
        zipEntry.setName(byArray);
        return zipEntry;
    }

    public ZipEntry readCEN(InputStream inputStream) throws IOException {
        this.buffer.clear();
        this.buffer.limit(46);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() == 0) {
            return null;
        }
        this.buffer.rewind();
        int n = this.buffer.getInt();
        if (n == 101010256) {
            return null;
        }
        if (n != 33639248) {
            throw new ZipException(String.format("invalid CEN header: signature=0x%X", n));
        }
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        short s3 = this.buffer.getShort();
        short s4 = this.buffer.getShort();
        short s5 = this.buffer.getShort();
        short s6 = this.buffer.getShort();
        int n2 = this.buffer.getInt();
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        short s7 = this.buffer.getShort();
        short s8 = this.buffer.getShort();
        short s9 = this.buffer.getShort();
        short s10 = this.buffer.getShort();
        short s11 = this.buffer.getShort();
        int n5 = this.buffer.getInt();
        int n6 = this.buffer.getInt();
        byte[] byArray = new byte[s7];
        if (inputStream.read(byArray) != s7) {
            throw new ZipException("invalid LOC header (name length)");
        }
        if (s8 > 0 && inputStream.skip(s8) != (long)s8) {
            throw new ZipException("invalid LOC header (extra length)");
        }
        ZipEntry zipEntry = new ZipEntry();
        zipEntry.signature = n;
        zipEntry.flags = s3;
        zipEntry.method = s4;
        zipEntry.mtime = s5;
        zipEntry.mdate = s6;
        zipEntry.crc = n2;
        zipEntry.compsize = n3;
        zipEntry.uncompsize = n4;
        zipEntry.extlen = s8;
        zipEntry.reloff = n6;
        zipEntry.setName(byArray);
        return zipEntry;
    }

    public ZipEndEntry readEND(InputStream inputStream) throws IOException {
        this.buffer.clear();
        this.buffer.limit(22);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() == 0) {
            return null;
        }
        this.buffer.rewind();
        int n = this.buffer.getInt();
        if (n != 101010256) {
            return null;
        }
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        short s3 = this.buffer.getShort();
        short s4 = this.buffer.getShort();
        int n2 = this.buffer.getInt();
        int n3 = this.buffer.getInt();
        short s5 = this.buffer.getShort();
        byte[] byArray = new byte[s5];
        if (s5 > 0 && inputStream.skip(s5) != (long)s5) {
            throw new ZipException("invalid END header (comment length)");
        }
        ZipEndEntry zipEndEntry = new ZipEndEntry();
        zipEndEntry.signature = n;
        zipEndEntry.disknum = s;
        zipEndEntry.disknumCEN = s2;
        zipEndEntry.countDiskCENs = s3;
        zipEndEntry.countCENs = s4;
        zipEndEntry.sizeCENs = n2;
        zipEndEntry.offsetStartCEN = n3;
        zipEndEntry.commentlen = s5;
        zipEndEntry.comment = byArray;
        return zipEndEntry;
    }

    public ZipEntry readEXT(InputStream inputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry();
        this.readEXT(inputStream, zipEntry);
        return zipEntry;
    }

    public boolean readEXT(InputStream inputStream, ZipEntry zipEntry) throws IOException {
        this.buffer.clear();
        this.buffer.limit(16);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() == 0) {
            return false;
        }
        this.buffer.rewind();
        int n = this.buffer.getInt();
        if (n != 134695760) {
            throw new ZipException(String.format("invalid EXT header: signature=0x%X", n));
        }
        int n2 = this.buffer.getInt();
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        zipEntry.extOverwritten = true;
        zipEntry.crc = n2;
        zipEntry.compsize = n3;
        zipEntry.uncompsize = n4;
        return true;
    }

    public void write(OutputStream outputStream, ZipEntry zipEntry) throws IOException {
        this.writeLOC(outputStream, zipEntry);
    }

    public void writeLOC(OutputStream outputStream, ZipEntry zipEntry) throws IOException {
        boolean bl = zipEntry.hasEXT();
        byte[] byArray = zipEntry.getNameAsBytes();
        if (byArray.length > Short.MAX_VALUE) {
            throw new ZipException("too long name: length=" + byArray.length);
        }
        zipEntry.reloff = (int)(this.offset & 0xFFFFFFFFL);
        int n = 67324752;
        short s = zipEntry.version;
        short s2 = zipEntry.flags;
        short s3 = zipEntry.method;
        short s4 = zipEntry.mtime;
        short s5 = zipEntry.mdate;
        int n2 = bl ? 0 : zipEntry.crc;
        int n3 = bl ? 0 : zipEntry.compsize;
        int n4 = bl ? 0 : zipEntry.uncompsize;
        short s6 = (short)(byArray.length & 0xFFFF);
        short s7 = zipEntry.extlen;
        assert (this.offset <= 0xFFFFFFFFL);
        this.buffer.clear();
        this.buffer.putInt(n);
        this.buffer.putShort(s);
        this.buffer.putShort(s2);
        this.buffer.putShort(s3);
        this.buffer.putShort(s4);
        this.buffer.putShort(s5);
        this.buffer.putInt(n2);
        this.buffer.putInt(n3);
        this.buffer.putInt(n4);
        this.buffer.putShort(s6);
        this.buffer.putShort(s7);
        assert (this.buffer.position() == 30);
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
        outputStream.write(byArray);
        outputStream.flush();
        this.entries.add(zipEntry);
        assert (s6 > 0);
        assert (s7 >= 0);
        assert (n3 >= 0);
        this.offset += (long)(30 + s6 + s7 + n3);
    }

    public void writeCEN(OutputStream outputStream, ZipEntry zipEntry) throws IOException {
        int n = 33639248;
        short s = zipEntry.version;
        short s2 = zipEntry.version;
        short s3 = zipEntry.flags;
        short s4 = zipEntry.method;
        short s5 = zipEntry.mtime;
        short s6 = zipEntry.mdate;
        int n2 = zipEntry.crc;
        int n3 = zipEntry.compsize;
        int n4 = zipEntry.uncompsize;
        byte[] byArray = zipEntry.getNameAsBytes();
        if (byArray.length > Short.MAX_VALUE) {
            throw new ZipException("too long name: length=" + byArray.length);
        }
        short s7 = (short)byArray.length;
        short s8 = 0;
        short s9 = 0;
        short s10 = 0;
        short s11 = 0;
        int n5 = 0;
        int n6 = zipEntry.reloff;
        this.buffer.clear();
        this.buffer.putInt(n);
        this.buffer.putShort(s);
        this.buffer.putShort(s2);
        this.buffer.putShort(s3);
        this.buffer.putShort(s4);
        this.buffer.putShort(s5);
        this.buffer.putShort(s6);
        this.buffer.putInt(n2);
        this.buffer.putInt(n3);
        this.buffer.putInt(n4);
        this.buffer.putShort(s7);
        this.buffer.putShort(s8);
        this.buffer.putShort(s9);
        this.buffer.putShort(s10);
        this.buffer.putShort(s11);
        this.buffer.putInt(n5);
        this.buffer.putInt(n6);
        assert (this.buffer.position() == 46);
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
        outputStream.write(byArray);
        outputStream.flush();
        this.offset += (long)(46 + s7 + s8);
    }

    public void writeEND(OutputStream outputStream) throws IOException {
        for (ZipEntry zipEntry : this.entries) {
            this.writeCEN(outputStream, zipEntry);
        }
        this.writeEND(outputStream, ZipEndEntry.create(this.offset, this.entries));
    }

    public void writeEND(OutputStream outputStream, ZipEndEntry zipEndEntry) throws IOException {
        int n = zipEndEntry.signature;
        short s = zipEndEntry.disknum;
        short s2 = zipEndEntry.disknumCEN;
        short s3 = zipEndEntry.countDiskCENs;
        short s4 = zipEndEntry.countCENs;
        int n2 = zipEndEntry.sizeCENs;
        int n3 = zipEndEntry.offsetStartCEN;
        short s5 = 0;
        byte[] byArray = new byte[]{};
        this.buffer.clear();
        this.buffer.putInt(n);
        this.buffer.putShort(s);
        this.buffer.putShort(s2);
        this.buffer.putShort(s3);
        this.buffer.putShort(s4);
        this.buffer.putInt(n2);
        this.buffer.putInt(n3);
        this.buffer.putShort(s5);
        this.buffer.put(byArray);
        assert (this.buffer.position() == 22);
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
        outputStream.flush();
        this.offset += 22L;
    }

    public void writeEXT(OutputStream outputStream, ZipEntry zipEntry) throws IOException {
        int n = 134695760;
        int n2 = zipEntry.crc;
        int n3 = zipEntry.compsize;
        int n4 = zipEntry.uncompsize;
        this.buffer.clear();
        this.buffer.putInt(n);
        this.buffer.putInt(n2);
        this.buffer.putInt(n3);
        this.buffer.putInt(n4);
        assert (this.buffer.position() == 16);
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
        outputStream.flush();
        this.offset += 16L;
        assert (zipEntry.compsize >= 0);
        this.offset += (long)zipEntry.compsize;
    }

    public void clearEntries() {
        this.entries.clear();
        this.offset = 0L;
    }
}

