/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.ArchiveFile;
import jp.sfjp.armadillo.archive.tar.TarException;
import jp.sfjp.armadillo.archive.zip.ZipEndEntry;
import jp.sfjp.armadillo.archive.zip.ZipEntry;
import jp.sfjp.armadillo.archive.zip.ZipHeader;
import jp.sfjp.armadillo.archive.zip.ZipInputStream;
import jp.sfjp.armadillo.archive.zip.ZipOutputStream;
import jp.sfjp.armadillo.io.IOUtilities;

public final class ZipFile
extends ArchiveFile {
    private File afile;
    private ZipHeader header;
    private RandomAccessFile raf;
    private ZipEntry ongoingEntry;
    private byte[] buffer;
    private ZipEndEntry endEntry;

    public ZipFile(File file) {
        this.afile = file;
        this.header = new ZipHeader();
    }

    public ZipFile(File file, boolean bl) throws IOException {
        this(file);
        this.open();
    }

    @Override
    public void open() throws IOException {
        if (this.raf != null) {
            throw new IOException("the file has been already opened");
        }
        if (!this.afile.exists()) {
            this.afile.createNewFile();
        }
        this.raf = new RandomAccessFile(this.afile, "rw");
        this.opened = true;
    }

    @Override
    public void reset() throws IOException {
        if (this.raf.length() == 0L) {
            this.endEntry = new ZipEndEntry();
        } else {
            this.endEntry = this.readEndHeader();
            if (this.endEntry == null) {
                throw new IllegalStateException("failed to read END header");
            }
        }
        this.ongoingEntry = null;
        this.currentPosition = this.endEntry.offsetStartCEN;
        this.raf.seek(this.currentPosition);
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        this.ensureOpen();
        if (this.ongoingEntry == null) {
            this.reset();
        } else {
            long l = 0L;
            l += 46L;
            l += (long)this.ongoingEntry.getNameAsBytes().length;
            this.currentPosition += (l += (long)this.ongoingEntry.extlen);
        }
        this.raf.seek(this.currentPosition);
        this.ongoingEntry = this.header.readCEN(Channels.newInputStream(this.raf.getChannel()));
        return this.ongoingEntry == null ? ArchiveEntry.NULL : this.ongoingEntry;
    }

    @Override
    public ArchiveEntry newEntry(String string) {
        return new ZipEntry(string);
    }

    @Override
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        long l2;
        this.reset();
        List<ZipEntry> list = this.getEntries();
        ZipEntry zipEntry = new ZipEntry(archiveEntry.getName());
        zipEntry.copyFrom(archiveEntry);
        this.raf.seek(this.endEntry.offsetStartCEN);
        ZipOutputStream zipOutputStream = new ZipOutputStream(Channels.newOutputStream(this.raf.getChannel()));
        zipOutputStream.putNextEntry(zipEntry);
        if (l > 0L) {
            l2 = IOUtilities.transfer(inputStream, zipOutputStream, l);
            assert (l2 == l);
            zipEntry.setCompressedSize(l2);
            zipEntry.setSize(l);
        }
        zipOutputStream.closeEntry();
        zipOutputStream.flush();
        l2 = this.raf.getFilePointer();
        this.raf.seek(this.endEntry.offsetStartCEN);
        zipEntry.flags = (short)(zipEntry.flags & 0xFFF7);
        zipOutputStream.putNextEntry(zipEntry);
        zipEntry.reloff = this.endEntry.offsetStartCEN;
        list.add(zipEntry);
        this.endEntry.countCENs = (short)list.size();
        this.raf.seek(l2);
        this.writeEnd(list);
    }

    @Override
    public void updateEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        super.updateEntry(archiveEntry, inputStream, l);
    }

    @Override
    public void removeEntry(ArchiveEntry archiveEntry) throws IOException {
        if (!this.seek(archiveEntry)) {
            throw new TarException("entry " + archiveEntry + " not found");
        }
        assert (this.ongoingEntry != null);
        ZipEntry zipEntry = this.ongoingEntry;
        ZipEndEntry zipEndEntry = this.endEntry;
        long l = zipEntry.reloff;
        List<ZipEntry> list = this.getEntries();
        this.raf.seek(l);
        ZipInputStream zipInputStream = new ZipInputStream(Channels.newInputStream(this.raf.getChannel()));
        ZipEntry zipEntry2 = zipInputStream.getNextEntry();
        zipInputStream.skip(zipEntry2.uncompsize);
        zipInputStream.closeEntry();
        long l2 = (long)this.getOffset() - l;
        zipEndEntry.offsetStartCEN = (int)((long)zipEndEntry.offsetStartCEN - l2);
        this.truncate(l, l2);
        for (ZipEntry zipEntry3 : list) {
            if (!zipEntry3.equalsName(zipEntry)) continue;
            list.remove(zipEntry3);
            break;
        }
        for (ZipEntry zipEntry3 : list) {
            if ((long)zipEntry3.reloff <= l) continue;
            zipEntry3.reloff = (int)((long)zipEntry3.reloff - l2);
        }
        this.raf.seek(zipEndEntry.offsetStartCEN);
        this.endEntry = zipEndEntry;
        this.writeEnd(list);
    }

    void writeEnd(List<ZipEntry> list) throws IOException {
        ZipEndEntry zipEndEntry = ZipEndEntry.create(this.getOffset(), list);
        OutputStream outputStream = Channels.newOutputStream(this.raf.getChannel());
        for (ZipEntry zipEntry : list) {
            this.header.writeCEN(outputStream, zipEntry);
        }
        this.header.writeEND(outputStream, zipEndEntry);
        if (this.raf.length() > this.raf.getFilePointer()) {
            this.raf.setLength(this.raf.getFilePointer());
        }
    }

    public void insertEmptySpace(long l, long l2) throws IOException {
        long l3 = l2 * 8192L;
        this.raf.seek(this.raf.length() + l3 - 1L);
        this.raf.write(0);
        long l4 = this.raf.getFilePointer();
        long l5 = l4 - 8192L;
        long l6 = l5 - l3;
        assert (l6 > 0L && l5 > 0L);
        byte[] byArray = this.buffer;
        int n = 0;
        while ((long)n < l2 && l6 >= l) {
            this.raf.seek(l6);
            this.raf.readFully(byArray);
            this.raf.seek(l5);
            this.raf.write(byArray);
            l6 -= 8192L;
            l5 -= 8192L;
            ++n;
        }
        this.currentPosition = l;
        this.raf.seek(this.currentPosition);
    }

    @Override
    public long extract(OutputStream outputStream) throws IOException {
        this.raf.seek(this.ongoingEntry.reloff);
        InputStream inputStream = Channels.newInputStream(this.raf.getChannel());
        ZipEntry zipEntry = this.header.read(inputStream);
        assert (zipEntry != null);
        zipEntry.compsize = this.ongoingEntry.compsize;
        zipEntry.uncompsize = this.ongoingEntry.uncompsize;
        zipEntry.flags = (short)(zipEntry.flags & 0xFFF7);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        zipInputStream.openEntry(zipEntry);
        return IOUtilities.transfer(zipInputStream, outputStream, this.ongoingEntry.uncompsize);
    }

    int getOffset() throws IOException {
        long l = this.raf.getFilePointer();
        if (l > Integer.MAX_VALUE) {
            throw new ZipException("size not supported: " + l);
        }
        return (int)l;
    }

    List<ZipEntry> getEntries() {
        ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>();
        for (ArchiveEntry archiveEntry : this) {
            arrayList.add((ZipEntry)archiveEntry);
        }
        return arrayList;
    }

    ZipEndEntry readEndHeader() throws IOException {
        this.raf.seek(this.raf.length() - 22L - 0L);
        return this.header.readEND(Channels.newInputStream(this.raf.getChannel()));
    }

    void truncate(long l, long l2) throws IOException {
        long l3 = l;
        long l4 = l3 + l2;
        byte[] byArray = new byte[8192];
        while (true) {
            this.raf.seek(l4);
            int n = this.raf.read(byArray);
            if (n <= 0) break;
            this.raf.seek(l3);
            this.raf.write(byArray, 0, n);
            l3 += (long)n;
            l4 += (long)n;
        }
        this.raf.setLength(this.raf.length() - l2);
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        finally {
            super.close();
            this.afile = null;
            this.header = null;
        }
    }
}

