/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.ArchiveExtractor;
import jp.sfjp.armadillo.archive.zip.ZipInputStream;
import jp.sfjp.armadillo.io.IOUtilities;

public final class ZipArchiveExtractor
implements ArchiveExtractor {
    private ZipInputStream is;

    public ZipArchiveExtractor(InputStream inputStream) {
        this.is = new ZipInputStream(inputStream);
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        return ArchiveEntry.orNull(this.is.getNextEntry());
    }

    @Override
    public long extract(OutputStream outputStream) throws IOException {
        return IOUtilities.transferAll(this.is, outputStream);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

