/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.tar;

import java.io.IOException;
import java.io.OutputStream;
import jp.sfjp.armadillo.archive.ArchiveOutputStream;
import jp.sfjp.armadillo.archive.tar.TarEntry;
import jp.sfjp.armadillo.archive.tar.TarHeader;

public final class TarOutputStream
extends ArchiveOutputStream {
    private TarHeader header = new TarHeader();
    private TarEntry nextEntry;

    public TarOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.frontStream = outputStream;
    }

    public void putNextEntry(TarEntry tarEntry) throws IOException {
        this.ensureOpen();
        this.nextEntry = tarEntry;
        this.header.write(this, tarEntry);
        this.written = 0L;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        int n = (int)TarHeader.getSkipSize(this.nextEntry.getSize());
        this.write(new byte[n]);
        this.flush();
        this.nextEntry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.header.writeEndOfArchive(this);
        }
        finally {
            try {
                super.close();
            }
            finally {
                this.header = null;
                this.nextEntry = null;
            }
        }
    }
}

