/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.lzh;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sfjp.armadillo.archive.ArchiveCreator;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.lzh.LzhEntry;
import jp.sfjp.armadillo.archive.lzh.LzhOutputStream;
import jp.sfjp.armadillo.io.IOUtilities;

public final class LzhArchiveCreator
implements ArchiveCreator {
    private LzhOutputStream os;

    public LzhArchiveCreator(OutputStream outputStream) {
        this.os = new LzhOutputStream(outputStream);
    }

    @Override
    public ArchiveEntry newEntry(String string) {
        LzhEntry lzhEntry = LzhArchiveCreator.newLzhEntry();
        lzhEntry.setName(string);
        return lzhEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        if (file.isDirectory()) {
            LzhEntry lzhEntry = LzhArchiveCreator.toLzhEntry(archiveEntry);
            lzhEntry.setMethod("-lhd-");
            this.os.putNextEntry(lzhEntry);
            this.os.closeEntry();
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.addEntry(archiveEntry, fileInputStream, file.length());
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        archiveEntry.setAdded(true);
    }

    @Override
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        LzhEntry lzhEntry = LzhArchiveCreator.toLzhEntry(archiveEntry);
        lzhEntry.setSize(l);
        this.os.putNextEntry(lzhEntry);
        long l2 = IOUtilities.transferAll(inputStream, this.os);
        this.os.closeEntry();
        assert (l2 == lzhEntry.getSize()) : "file size";
        assert (l2 == l) : "file size";
        archiveEntry.setSize(l2);
        archiveEntry.setAdded(true);
    }

    static LzhEntry toLzhEntry(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof LzhEntry) {
            return (LzhEntry)archiveEntry;
        }
        LzhEntry lzhEntry = LzhArchiveCreator.newLzhEntry();
        archiveEntry.copyTo(lzhEntry);
        return lzhEntry;
    }

    private static LzhEntry newLzhEntry() {
        return new LzhEntry(2);
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

