/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.lzh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import jp.sfjp.armadillo.archive.DumpArchiveHeader;
import jp.sfjp.armadillo.archive.lzh.LzhException;
import jp.sfjp.armadillo.io.RewindableInputStream;
import jp.sfjp.armadillo.time.FTime;
import jp.sfjp.armadillo.time.FileTime;
import jp.sfjp.armadillo.time.TimeT;

public final class DumpLzhHeader
extends DumpArchiveHeader {
    private static final TimeT TIME_T = new TimeT();
    private static final FTime FTIME = new FTime();
    private static final FileTime FILETIME = new FileTime();
    private static final int siglen = 5;
    private static final int siglen_m1 = 4;
    private static final int USHORT_MASK = 65535;
    private static final int UBYTE_MASK = 255;
    private static final int BUFFER_SIZE = 1024;
    private static final int LEVEL_OFFSET = 20;
    private static final byte PATH_DELIMITER = -1;
    private static final String ERROR_PREFIX = "invalid header: ";
    private final ByteBuffer buffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);

    @Override
    public void dump(InputStream inputStream, PrintWriter printWriter) throws IOException {
        byte[] byArray = new byte[65536];
        long l = 0L;
        RewindableInputStream rewindableInputStream = new RewindableInputStream(inputStream, 65536);
        while (true) {
            Arrays.fill(byArray, (byte)0);
            int n = rewindableInputStream.read(byArray);
            if (n <= 0) break;
            int n2 = DumpLzhHeader.findHeader(byArray);
            if (n2 < 0) {
                if (n < 5) break;
                rewindableInputStream.rewind(4);
                l += (long)(n - 4);
                continue;
            }
            int n3 = n2 - 2;
            if (n2 != 0 && n2 >= 65531) {
                throw new AssertionError((Object)"else");
            }
            rewindableInputStream.rewind(n - n3);
            this.printOffset(printWriter, l += (long)n3);
            try {
                l += this.dumpHeader(rewindableInputStream, printWriter);
            }
            catch (Exception exception) {
                DumpLzhHeader.warn(printWriter, "unexpected error: %s", exception);
                l += 7L;
            }
        }
        this.printEnd(printWriter, "LZH", l);
    }

    static int findHeader(byte[] byArray) {
        for (int i = 0; i < byArray.length - 4; ++i) {
            if (byArray[i] != 45 || byArray[i + 1] != 108 || byArray[i + 4] != 45) continue;
            return i;
        }
        return -1;
    }

    public long dumpHeader(InputStream inputStream, PrintWriter printWriter) throws IOException {
        long l;
        int n;
        this.buffer.clear();
        this.buffer.limit(21);
        Channels.newChannel(inputStream).read(this.buffer);
        int n2 = this.buffer.position();
        if (n2 == 0 || n2 == 1 && this.buffer.get(0) == 0 || n2 <= 21 && this.buffer.getShort(0) == 0) {
            return -1L;
        }
        if (n2 != 21) {
            return -1L;
        }
        byte by = this.buffer.get(20);
        this.buffer.rewind();
        switch (by) {
            case 0: 
            case 1: {
                n = (this.buffer.get() & 0xFF) + 2;
                break;
            }
            case 2: {
                n = this.buffer.getShort() & 0xFFFF;
                break;
            }
            default: {
                throw new LzhException("unsupported header level (=" + by + ")");
            }
        }
        if (n == 0) {
            return -1L;
        }
        assert (n >= 0 && n < 1024) : "header length = " + n;
        this.buffer.limit(n);
        this.buffer.position(21);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() != n) {
            throw new LzhException("invalid header: header length = " + n);
        }
        switch (by) {
            case 0: {
                l = this.dumpLevel0(inputStream, printWriter);
                break;
            }
            case 1: {
                l = this.dumpLevel1(inputStream, printWriter);
                break;
            }
            case 2: {
                l = this.dumpLevel2(inputStream, printWriter);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected state");
            }
        }
        return l;
    }

    private long dumpLevel0(InputStream inputStream, PrintWriter printWriter) throws IOException {
        long l = 0L;
        this.buffer.position(0);
        byte by = this.buffer.get();
        byte by2 = this.buffer.get();
        byte[] byArray = this.getBytes(5);
        int n = this.buffer.getInt();
        int n2 = this.buffer.getInt();
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        byte by3 = this.buffer.get();
        byte by4 = this.buffer.get();
        byte by5 = this.buffer.get();
        byte[] byArray2 = this.getBytes(by5);
        short s3 = this.buffer.getShort();
        short s4 = this.buffer.getShort();
        this.printHeaderName(printWriter, "Level 0 Header");
        this.p(printWriter, "headerLength", by);
        this.p(printWriter, "checksum", by2);
        this.p(printWriter, "method", byArray);
        this.p(printWriter, "skipSize", n);
        this.p(printWriter, "size", n2);
        this.p(printWriter, "mtime", s);
        this.p(printWriter, "mdate", s2);
        this.p(printWriter, "attribute", by3);
        this.p(printWriter, "level", by4);
        this.p(printWriter, "nameLength", by5);
        this.p(printWriter, "name", byArray2);
        this.p(printWriter, "crc", s3);
        this.p(printWriter, "extend", s4);
        l += (long)this.buffer.position();
        if (n > 0) {
            l += inputStream.skip(n);
        }
        return l;
    }

    private long dumpLevel1(InputStream inputStream, PrintWriter printWriter) throws IOException {
        long l = 0L;
        this.buffer.position(0);
        byte by = this.buffer.get();
        byte by2 = this.buffer.get();
        byte[] byArray = this.getBytes(5);
        int n = this.buffer.getInt();
        int n2 = this.buffer.getInt();
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        byte by3 = this.buffer.get();
        byte by4 = this.buffer.get();
        byte by5 = this.buffer.get();
        byte[] byArray2 = this.getBytes(by5);
        short s3 = this.buffer.getShort();
        byte by6 = this.buffer.get();
        short s4 = this.buffer.getShort();
        this.printHeaderName(printWriter, "Level 1 Header");
        this.p(printWriter, "headerLength", by);
        this.p(printWriter, "checksum", by2);
        this.p(printWriter, "method", byArray);
        this.p(printWriter, "skipSize", n);
        this.p(printWriter, "size", n2);
        this.p(printWriter, "mtime", s);
        this.p(printWriter, "mdate", s2);
        this.p(printWriter, "reserved", by3);
        this.p(printWriter, "level", by4);
        this.p(printWriter, "nameLength", by5);
        this.p(printWriter, "name", byArray2);
        this.p(printWriter, "crc", (long)s3 & 0xFFFFFFFFL);
        this.p(printWriter, "osIdentifier", by6);
        this.p(printWriter, "extendHeaderSize", s4);
        l += (long)this.buffer.position();
        if (n > 0) {
            l += inputStream.skip(n);
        }
        return l;
    }

    private long dumpLevel2(InputStream inputStream, PrintWriter printWriter) throws IOException {
        int n;
        long l = 0L;
        this.buffer.position(0);
        short s = this.buffer.getShort();
        byte[] byArray = this.getBytes(5);
        int n2 = this.buffer.getInt();
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        byte by = this.buffer.get();
        byte by2 = this.buffer.get();
        short s2 = this.buffer.getShort();
        byte by3 = this.buffer.get();
        short s3 = this.buffer.getShort();
        String string = new String(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n5 = 0;
        short s4 = s3;
        while (s4 > 0) {
            n = this.buffer.get();
            int n6 = s4 - 3;
            this.buffer.mark();
            arrayList.add(String.format("ex: id=%02X, len=%d", (byte)n, n6));
            switch (n) {
                case 0: {
                    long l2 = this.buffer.getShort();
                    arrayList.add(String.format("  hCRC=0x%04X", l2 & 0xFFFFL));
                    try {
                        int n7 = n6 - 2;
                        for (int i = 0; i < n7; ++i) {
                            arrayList.add(String.format("  [%d]=%02X", i, this.buffer.get() & 0xFF));
                        }
                        break;
                    }
                    catch (Exception exception) {
                        DumpLzhHeader.warn(printWriter, ">>> %s", exception);
                        return this.buffer.position();
                    }
                }
                case 1: {
                    byteArrayOutputStream.write(this.nextPath(n6));
                    break;
                }
                case 2: {
                    byteArrayOutputStream2.write(this.nextPath(n6));
                    break;
                }
                case 65: {
                    long l3 = this.buffer.getLong();
                    long l4 = this.buffer.getLong();
                    long l5 = this.buffer.getLong();
                    Date date = new Date(FILETIME.toMilliseconds(l3));
                    Date date2 = new Date(FILETIME.toMilliseconds(l4));
                    Date date3 = new Date(FILETIME.toMilliseconds(l5));
                    arrayList.add(String.format("  Windows ctime = %s (%d)", date, l3));
                    arrayList.add(String.format("  Windows mtime = %s (%d)", date2, l4));
                    arrayList.add(String.format("  Windows atime = %s (%d)", date3, l5));
                    break;
                }
                case 66: {
                    arrayList.add("  MS compsize = " + this.buffer.getLong());
                    arrayList.add("  MS filesize = " + this.buffer.getLong());
                    break;
                }
                case 84: {
                    long l6 = this.buffer.getLong();
                    Date date = new Date(FILETIME.toMilliseconds(l6));
                    arrayList.add(String.format("  UNIX mtime = %s (%d)", date, l6));
                    break;
                }
                default: {
                    for (int i = 0; i < n6; ++i) {
                        arrayList.add(String.format("  [%d]=%02X", i, this.buffer.get() & 0xFF));
                    }
                }
            }
            this.buffer.reset();
            this.buffer.position(this.buffer.position() + n6);
            s4 = this.buffer.getShort();
            n5 = this.buffer.position();
        }
        n = n5;
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        if (byteArrayOutputStream2.size() > 0) {
            byteArrayOutputStream3.write(byteArrayOutputStream2.toByteArray());
            if (!byteArrayOutputStream3.toString().endsWith("/")) {
                byteArrayOutputStream3.write(47);
            }
        }
        if (byteArrayOutputStream.size() > 0) {
            byteArrayOutputStream3.write(byteArrayOutputStream.toByteArray());
        }
        this.printHeaderName(printWriter, "Level 2 Header");
        this.p(printWriter, "name", byteArrayOutputStream3.toByteArray());
        this.p(printWriter, "mtime as Date", new Date(TIME_T.toMilliseconds(n4)));
        this.p(printWriter, "method", string);
        this.p(printWriter, "headerLength", s);
        this.p(printWriter, "compressedSize", n2);
        this.p(printWriter, "size", n3);
        this.p(printWriter, "mtime", n4);
        this.p(printWriter, "reserved", by);
        this.p(printWriter, "level", by2);
        this.p(printWriter, "crc", s2);
        this.p(printWriter, "osIdentifier", Character.valueOf((char)by3));
        this.p(printWriter, "firstExHdrLen", s3);
        for (String string2 : arrayList) {
            this.p(printWriter, "  ", string2);
        }
        if (s != n) {
            DumpLzhHeader.warn(printWriter, "header length is expected %d , but was %d%n", s, n5);
        }
        l += (long)n;
        if (n2 > 0) {
            l += inputStream.skip(n2);
        }
        return l;
    }

    private void p(PrintWriter printWriter, String string, Object object) {
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            printWriter.printf("  %-16s [%04X] ('%s')%n", string, (int)c, object);
        } else if (object instanceof Number) {
            int n;
            long l;
            if (object instanceof Byte) {
                l = (Byte)object & 0xFF;
                n = 2;
            } else if (object instanceof Short) {
                l = (Short)object & 0xFFFF;
                n = 4;
            } else if (object instanceof Integer) {
                l = (long)((Integer)object).intValue() & 0xFFFFFFFFL;
                n = 8;
            } else {
                l = ((Number)object).longValue();
                n = 1;
            }
            printWriter.printf("  %-16s [%0" + n + "X] (%d)%n", string, object, l);
        } else if (object instanceof byte[]) {
            printWriter.printf("  * %s = %s%n", string, new String((byte[])object));
        } else if (object instanceof Date) {
            printWriter.printf("  * %s = %s%n", string, object);
        } else {
            printWriter.printf("  %s %s%n", string, object);
        }
    }

    private byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.buffer.get();
        }
        return byArray;
    }

    private byte[] nextPath(int n) {
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFFFFFFFF) != -1) continue;
            byArray[i] = 47;
        }
        return byArray;
    }

    static Date toDate(int n, int n2) {
        int n3 = n << 16 | n2 & 0xFFFF;
        return new Date(FTIME.toMilliseconds(n3));
    }
}

