/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.cab;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Date;
import jp.sfjp.armadillo.archive.DumpArchiveHeader;
import jp.sfjp.armadillo.archive.cab.CabException;
import jp.sfjp.armadillo.time.FTime;

public final class DumpCabHeader
extends DumpArchiveHeader {
    static final int SIGNATURE = 1297302342;
    private static final FTime FTIME = new FTime();
    private static final String fmt0 = "  -- %s[%d] --%n";
    private static final String fmt1 = "  * %s = %s%n";
    private static final String fmt2 = "  %1$-16s = [0x%2$08X] ( %2$d )%n";
    private static final int BUFFER_SIZE = 1024;
    private final ByteBuffer buffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);
    private short[] folderCompressType;

    @Override
    public void dump(InputStream inputStream, PrintWriter printWriter) throws IOException {
        int n;
        short s;
        int n2;
        int n3;
        int n4;
        this.buffer.clear();
        this.buffer.limit(36);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() == 0) {
            throw new CabException("reading archive header, but position is zero");
        }
        this.buffer.rewind();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int n5 = this.buffer.getInt();
        if (n5 != 1297302342) {
            throw new CabException("bad signature: 0x%X", n5);
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int n6 = this.buffer.getInt();
        int n7 = this.buffer.getInt();
        int n8 = this.buffer.getInt();
        int n9 = this.buffer.getInt();
        int n10 = this.buffer.getInt();
        byte by = this.buffer.get();
        byte by2 = this.buffer.get();
        int n11 = this.buffer.getShort();
        int n12 = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        short s3 = this.buffer.getShort();
        short s4 = this.buffer.getShort();
        this.printHeaderName(printWriter, "Cabinet File header");
        printWriter.printf(fmt2, "signature", n5);
        printWriter.printf(fmt2, "reserved1", n6);
        printWriter.printf(fmt2, "cbCabinet", n7);
        printWriter.printf(fmt2, "reserved2", n8);
        printWriter.printf(fmt2, "coffFiles", n9);
        printWriter.printf(fmt2, "reserved3", n10);
        printWriter.printf(fmt2, "versionMinor", by);
        printWriter.printf(fmt2, "versionMajor", by2);
        printWriter.printf(fmt2, "cFolders", (short)n11);
        printWriter.printf(fmt2, "cFiles", (short)n12);
        printWriter.printf(fmt2, "flags", s2);
        printWriter.printf(fmt2, "setID", s3);
        printWriter.printf(fmt2, "iCabinet", s4);
        if (s4 != 0) {
            DumpCabHeader.warn(printWriter, "iCabinet not supported: 0x%d", s4);
            return;
        }
        this.folderCompressType = new short[n11];
        this.printHeaderName(printWriter, "CFFOLDER headers");
        int n13 = 0;
        for (n4 = 0; n4 < n11; ++n4) {
            this.buffer.clear();
            this.buffer.limit(8);
            Channels.newChannel(inputStream).read(this.buffer);
            if (this.buffer.position() == 0) {
                DumpCabHeader.warn(printWriter, "reading CFFOLDER header, but position is zero", new Object[0]);
                return;
            }
            this.buffer.rewind();
            n3 = this.buffer.getInt();
            n2 = this.buffer.getShort();
            s = this.buffer.getShort();
            byte[] byArray = new byte[]{};
            this.folderCompressType[n4] = s;
            printWriter.printf(fmt0, "CFFOLDER", n4);
            printWriter.printf(fmt2, "coffCabStart", n3);
            printWriter.printf(fmt2, "cCFData", (short)n2);
            printWriter.printf(fmt2, "typeCompress", s);
            n13 += n2;
        }
        this.printHeaderName(printWriter, "CFFILE headers");
        for (n4 = 0; n4 < n12; ++n4) {
            this.buffer.clear();
            this.buffer.limit(16);
            Channels.newChannel(inputStream).read(this.buffer);
            if (this.buffer.position() == 0) {
                throw new CabException("reading CFFILE header, but position is zero");
            }
            this.buffer.rewind();
            n3 = this.buffer.getInt();
            n2 = this.buffer.getInt();
            s = this.buffer.getShort();
            short s5 = this.buffer.getShort();
            short s6 = this.buffer.getShort();
            n = this.buffer.getShort();
            byte[] byArray = this.readName(inputStream, 256);
            String string = new String(byArray);
            printWriter.printf(fmt0, "CFFILE", n4);
            printWriter.printf(fmt1, "name", string);
            printWriter.printf(fmt1, "mtime as date", DumpCabHeader.toDate(s5, s6));
            printWriter.printf(fmt2, "cbFile", n3);
            printWriter.printf(fmt2, "uoffFolderStart", n2);
            printWriter.printf(fmt2, "iFolder", s);
            printWriter.printf(fmt2, "date", s5);
            printWriter.printf(fmt2, "time", s6);
            printWriter.printf(fmt2, "attribs", (short)n);
            printWriter.printf(fmt2, "szName.length", byArray.length);
        }
        this.printHeaderName(printWriter, "CFDATA headers");
        for (n4 = 0; n4 < n13; ++n4) {
            this.buffer.clear();
            this.buffer.limit(8);
            Channels.newChannel(inputStream).read(this.buffer);
            if (this.buffer.position() < 8) break;
            this.buffer.rewind();
            n3 = this.buffer.getInt();
            n2 = this.buffer.getShort();
            s = this.buffer.getShort();
            printWriter.printf(fmt0, "CFDATA", n4);
            printWriter.printf(fmt2, "csum", n3);
            printWriter.printf(fmt2, "cbData", (short)n2);
            printWriter.printf(fmt2, "cbUncomp", s);
            n = n2;
            while (n > 0) {
                n = (int)((long)n - inputStream.skip(n));
            }
        }
        this.printEnd(printWriter, "CAB", 0L);
    }

    static Date toDate(int n, int n2) {
        int n3 = n << 16 | n2 & 0xFFFF;
        return new Date(FTIME.toMilliseconds(n3));
    }

    private byte[] readName(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n && (n2 = inputStream.read()) > 0; ++i) {
            byArray[i] = (byte)(n2 & 0xFF);
            ++n3;
        }
        if (n3 < n) {
            return Arrays.copyOf(byArray, n3);
        }
        return byArray;
    }
}

