/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.cab;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jp.sfjp.armadillo.archive.ArchiveOutputStream;
import jp.sfjp.armadillo.archive.cab.CabCfFile;
import jp.sfjp.armadillo.archive.cab.CabCfFolder;
import jp.sfjp.armadillo.archive.cab.CabEntry;
import jp.sfjp.armadillo.archive.cab.CabHeader;

public final class CabOutputStream
extends ArchiveOutputStream {
    private final CabHeader header = new CabHeader();
    private final List<CabCfFolder> folders = new ArrayList<CabCfFolder>();
    private CabCfFolder currentFolder = new CabCfFolder("*");

    public CabOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void putNextEntry(CabEntry cabEntry) throws IOException {
        this.ensureOpen();
        String string = cabEntry.getName();
        if (string.length() > 255) {
            throw new IllegalArgumentException("too long name: " + string);
        }
        if (cabEntry.isDirectory()) {
            CabCfFolder cabCfFolder = (CabCfFolder)cabEntry;
            if (this.folders.isEmpty() || cabCfFolder.method != this.currentFolder.method) {
                this.currentFolder.method = cabCfFolder.method;
            }
        } else {
            if (this.folders.isEmpty()) {
                this.changeFolder(this.getParentPath(cabEntry));
            }
            CabCfFile cabCfFile = (CabCfFile)cabEntry;
            int n = this.folders.size() - 1;
            assert (n <= Short.MAX_VALUE);
            cabCfFile.folderIndex = (short)n;
            cabCfFile.uncompressedOffset = this.currentFolder.offset;
            this.currentFolder.offset += cabCfFile.uncompressedSize;
            this.currentFolder.add(cabCfFile);
        }
    }

    void changeFolder(String string) throws IOException {
        this.currentFolder.close();
        CabCfFolder cabCfFolder = new CabCfFolder(CabOutputStream.normalizePath(string, true));
        cabCfFolder.method = 1;
        this.folders.add(cabCfFolder);
        this.currentFolder = cabCfFolder;
        this.frontStream = this.currentFolder.bos;
    }

    void closeFolder(CabCfFolder cabCfFolder) throws IOException {
        this.ensureOpen();
        this.flush();
        cabCfFolder.close();
        this.frontStream = this.out;
    }

    String getParentPath(CabEntry cabEntry) {
        String string = CabOutputStream.normalizePath(cabEntry.getName(), false);
        return string.replaceFirst("/[^/]+$", "/");
    }

    static String normalizePath(String string, boolean bl) {
        String string2 = string.replace('\\', '/');
        if (bl && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string2;
    }

    public void closeEntry() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.currentFolder.close();
            this.header.write(this.out, this.folders);
            for (CabCfFolder cabCfFolder : this.folders) {
                cabCfFolder.writeCfDataInto(this.out, this.header);
            }
            this.out.flush();
            this.flush();
            this.folders.clear();
        }
        finally {
            super.close();
        }
    }
}

