/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.cab;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import jp.sfjp.armadillo.archive.ArchiveInputStream;
import jp.sfjp.armadillo.archive.cab.CabCompressionType;
import jp.sfjp.armadillo.archive.cab.CabEntry;
import jp.sfjp.armadillo.archive.cab.CabException;
import jp.sfjp.armadillo.archive.cab.CabHeader;
import jp.sfjp.armadillo.io.IOUtilities;

public final class CabInputStream
extends ArchiveInputStream {
    private final CabHeader header = new CabHeader();
    private int index = 0;

    public CabInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public CabInputStream(InputStream inputStream, boolean bl) throws IOException {
        this(inputStream);
        if (bl) {
            this.header.initialize(inputStream);
        }
    }

    public CabEntry getNextEntry() throws IOException {
        this.ensureOpen();
        CabEntry cabEntry = this.header.read(this.in);
        if (cabEntry == null) {
            return null;
        }
        boolean bl = this.index == 0;
        ++this.index;
        this.remaining = cabEntry.getSize();
        if (bl) {
            CabCompressionType cabCompressionType = CabCompressionType.of((short)1);
            switch (cabCompressionType) {
                case No: {
                    this.frontStream = this.in;
                    break;
                }
                case MSZIP: {
                    this.frontStream = new CfDataInflateInputStream(this.in);
                    break;
                }
                default: {
                    throw new CabException("Unsupported compression type: %s(0x%X)", new Object[]{cabCompressionType, (short)1});
                }
            }
        }
        return cabEntry;
    }

    static final class CfDataInflateInputStream
    extends FilterInputStream {
        private static final int BLOCK_SIZE = 32768;
        private final Inflater inflater;
        private byte[] inflaterBuffer;

        CfDataInflateInputStream(InputStream inputStream) {
            this(inputStream, new Inflater(true));
        }

        CfDataInflateInputStream(InputStream inputStream, Inflater inflater) {
            super(inputStream);
            this.inflater = inflater;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) < 1) {
                return -1;
            }
            return byArray[0];
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4;
            if (this.inflaterBuffer == null) {
                this.refill();
            }
            int n5 = n;
            for (n3 = n2; n3 > 0; n3 -= n4) {
                try {
                    n4 = this.inflater.inflate(byArray, n5, n3);
                }
                catch (DataFormatException dataFormatException) {
                    throw new CabException("data format error", dataFormatException);
                }
                if (n4 < 0) {
                    throw new CabException("illegal state");
                }
                if (n4 == 0) {
                    if (this.inflater.needsDictionary()) {
                        throw new CabException("change dictionary not supported");
                    }
                    if (this.inflater.finished()) {
                        if (this.inflater.getTotalOut() != 32768) break;
                        this.refill();
                    }
                    if (this.inflater.needsInput()) {
                        this.refill();
                    }
                }
                n5 += n4;
            }
            assert (n3 >= 0);
            return n2 - n3;
        }

        void refill() throws IOException {
            byte[] byArray = new byte[32768];
            int n = this.readNextBlock(byArray, 0);
            if (n < 1) {
                throw new CabException("illegal state");
            }
            int n2 = this.inflater.getRemaining();
            byte[] byArray2 = new byte[n2 + n];
            if (n2 > 0) {
                assert (this.inflaterBuffer != null);
                int n3 = this.inflaterBuffer.length - n2;
                System.arraycopy(this.inflaterBuffer, n3, byArray2, 0, n2);
            }
            System.arraycopy(byArray, 0, byArray2, n2, n);
            this.inflater.reset();
            this.inflater.setInput(byArray2);
            this.inflaterBuffer = byArray2;
        }

        int readNextBlock(byte[] byArray, int n) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.clear();
            Channels.newChannel(this.in).read(byteBuffer);
            if (byteBuffer.position() == 0) {
                return -1;
            }
            if (byteBuffer.position() != 8) {
                throw new CabException("reading CFDATA header error: %d", byteBuffer.position());
            }
            byteBuffer.rewind();
            int n2 = byteBuffer.getInt();
            short s = byteBuffer.getShort();
            short s2 = byteBuffer.getShort();
            byte[] byArray2 = new byte[s];
            int n3 = IOUtilities.read(this.in, byArray2, 0, s);
            if (n3 != s) {
                throw new CabException("failed to inflate (fill)");
            }
            if (byArray2[0] != 67 || byArray2[1] != 75) {
                throw new CabException("bad CFDATA block (%02X%02X)", byArray2[0], byArray2[1]);
            }
            System.arraycopy(byArray2, 2, byArray, n, n3 - 2);
            return n3 - 2;
        }
    }
}

