/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.cab;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jp.sfjp.armadillo.archive.cab.CabCfData;
import jp.sfjp.armadillo.archive.cab.CabCfFile;
import jp.sfjp.armadillo.archive.cab.CabCompressionType;
import jp.sfjp.armadillo.archive.cab.CabEntry;
import jp.sfjp.armadillo.archive.cab.CabHeader;

public final class CabCfFolder
extends CabEntry {
    final List<CabCfFile> files = new ArrayList<CabCfFile>();
    ByteArrayOutputStream bos;
    CabCfData currentCabCfData;
    short method;
    int checksum;
    int offset;
    final List<CabCfData> arrayOfCfData = new ArrayList<CabCfData>();

    public CabCfFolder() {
    }

    public CabCfFolder(String string) {
        this();
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.setName(string);
        this.bos = new ByteArrayOutputStream();
    }

    public void writeCfDataInto(OutputStream outputStream, CabHeader cabHeader) throws IOException {
        for (CabCfData cabCfData : this.arrayOfCfData) {
            cabHeader.writeCfDataHeader(outputStream, cabCfData);
            cabCfData.writeInto(outputStream);
        }
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public void setSize(long l) {
    }

    @Override
    public long getCompressedSize() {
        return 0L;
    }

    @Override
    public void setCompressedSize(long l) {
    }

    @Override
    public void setLastModified(long l) {
    }

    public boolean add(CabCfFile cabCfFile) {
        return this.files.add(cabCfFile);
    }

    public int getCompressedDataSize() {
        int n = 0;
        for (CabCfData cabCfData : this.arrayOfCfData) {
            n += cabCfData.bos.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int n = this.bos.size();
        byte[] byArray = this.bos.toByteArray();
        int n2 = n;
        int n3 = n == 0 ? 0 : (n < 32768 ? 1 : n / 32768 + 1);
        int n4 = 0;
        this.method = 1;
        for (int i = 0; i < n3; ++i) {
            CabCfData cabCfData = new CabCfData(CabCompressionType.of(this.method));
            try {
                int n5 = n2 > 32768 ? 32768 : n2;
                cabCfData.write(byArray, n4, n5);
                n4 += 32768;
                n2 -= 32768;
            }
            finally {
                cabCfData.close();
            }
            this.arrayOfCfData.add(cabCfData);
        }
        this.bos = null;
    }
}

