/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.cab;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sfjp.armadillo.archive.ArchiveCreator;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.cab.CabEntry;
import jp.sfjp.armadillo.archive.cab.CabOutputStream;
import jp.sfjp.armadillo.io.IOUtilities;

public final class CabArchiveCreator
implements ArchiveCreator {
    private CabOutputStream os;

    public CabArchiveCreator(OutputStream outputStream) {
        this.os = new CabOutputStream(outputStream);
    }

    @Override
    public ArchiveEntry newEntry(String string) {
        return CabEntry.getInstance(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        if (file.isDirectory()) {
            this.os.putNextEntry(CabArchiveCreator.toCabEntry(archiveEntry));
            this.os.closeEntry();
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.addEntry(archiveEntry, fileInputStream, file.length());
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        archiveEntry.setAdded(true);
    }

    @Override
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        CabEntry cabEntry = CabArchiveCreator.toCabEntry(archiveEntry);
        cabEntry.setSize(l);
        this.os.putNextEntry(cabEntry);
        long l2 = IOUtilities.transferAll(inputStream, this.os);
        this.os.closeEntry();
        assert (l2 == cabEntry.getSize()) : "file size";
        assert (l2 == l) : "file size";
        archiveEntry.setSize(l2);
        archiveEntry.setAdded(true);
    }

    static CabEntry toCabEntry(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof CabEntry) {
            return (CabEntry)archiveEntry;
        }
        CabEntry cabEntry = CabEntry.getInstance(archiveEntry.getName());
        archiveEntry.copyTo(cabEntry);
        return cabEntry;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

