/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ArchiveOutputStream
extends FilterOutputStream {
    protected OutputStream frontStream;
    protected long written;
    private boolean closed;

    public ArchiveOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    protected final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            super.write(n);
        } else {
            this.frontStream.write(n);
        }
        ++this.written;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            super.write(byArray, n, n2);
        } else {
            this.frontStream.write(byArray, n, n2);
        }
        this.written += (long)n2;
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            super.flush();
        } else {
            this.frontStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.closed = true;
            this.frontStream = null;
            super.close();
        }
    }
}

