package jp.sourceforge.armadillo.lzh;

import java.io.*;

import jp.sourceforge.armadillo.io.*;

/**
 * LZH`A[JCu̓̓Xg[B
 */
public final class LzhInputStream extends ArchiveInputStream {

    private LzhHeader header;
    private LzhEntry nextEntry;

    /**
     * LzhInputStream̐B
     * @param is InputStream
     */
    public LzhInputStream(InputStream is) {
        super(is);
        this.header = new LzhHeader();
    }

    /**
     * ̃Gg擾B
     * @return LzhEntry ̃Ggꍇ <code>null</code>
     * @throws IOException o̓G[ꍇ
     */
    public LzhEntry getNextEntry() throws IOException {
        ensureOpen();
        if (remaining > 0) {
            closeEntry();
        }
        LzhEntry entry = header.read(in);
        if (entry == null) {
            return null;
        }
        LzhMethod method = new LzhMethod(entry.method);
        if (method.isCompressing()) {
            frontStream = new LzssInputStream(new LzhHuffmanDecoder(in, entry.compressedSize),
                                              method.getDictionarySize(),
                                              method.getMatchSize(),
                                              method.getThreshold());
        } else {
            frontStream = in;
        }
        remaining = entry.size;
        nextEntry = entry;
        return entry;
    }

    /**
     * ݂̃GgB
     * @throws IOException o̓G[ꍇ
     */
    public void closeEntry() throws IOException {
        ensureOpen();
        if (remaining == nextEntry.size) {
            frontStream = in;
            remaining = nextEntry.compressedSize;
        }
        while (remaining > 0) {
            skip(remaining);
        }
        assert remaining == 0 : "rest=" + remaining;
        nextEntry = null;
        frontStream = in;
    }

    /* (overridden)
     * @see java.io.InputStream#close()
     */
    public void close() throws IOException {
        header = null;
        super.close();
    }

}
