package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * rbgPʂ̓ǂݍ݂\InputStreamB
 */
public final class BitInputStream extends FilterInputStream {

    /**
     * <code>int</code>̃rbgB
     */
    private static final int INT_BITSIZE = 32;

    /**
     * ͂̓ǂݍ݃rbgB
     */
    private static final int INPUT_BITSIZE = 8;

    private boolean closed;
    private int buffer;
    private int remaining;
    private boolean eof;

    /**
     * BitInputStream̐B
     * @param is InputStream
     */
    public BitInputStream(InputStream is) {
        super(is);
        this.closed = false;
        this.buffer = 0;
        this.remaining = 0;
        this.eof = false;
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    private void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream already closed");
        }
    }

    /**
     * w肵rbg̒lǂݍށB
     * @param bitLength rbg
     * @return w肵rbg̒l ǂݍ񂾒l <code>EOF</code> ̏ꍇ <code>-1</code>
     * @throws IOException o̓G[ꍇ
     */
    public int readBits(int bitLength) throws IOException {
        ensureOpen();
        if (bitLength < 1 || 32 < bitLength) {
            throw new IllegalArgumentException("bit length: " + bitLength);
        }
        if (remaining < bitLength) {
            fillBuffer(bitLength);
            if (remaining == 0) {
                return -1;
            } else if (remaining < bitLength) {
                throw new IOException("requred=" + bitLength + ", remaining=" + remaining);
            }
        }
        int value = buffer >>> (INT_BITSIZE - bitLength);
        remaining -= bitLength;
        buffer <<= bitLength;
        return value;
    }

    /**
     * 1rbgǂݍށB
     * @return 1rbg̒l ǂݍ񂾒l <code>EOF</code> ̏ꍇ <code>-1</code>
     * @throws IOException o̓G[ꍇ
     */
    public int readBit() throws IOException {
        return readBits(1);
    }

    /**
     * rbgǂ݂B
     * LbVĂlw肵rbgɖȂꍇA̓Xg[ǂݍށB
     * ɁA̓Xg[EOFԂꍇAsrbg<code>0</code>₤B
     * @param bitLength rbg
     * @return w肵rbg̒l ǂݍ񂾒l <code>EOF</code> ̏ꍇ <code>-1</code>
     * @throws IOException o̓G[ꍇ 
     */
    public int prefetchBits(int bitLength) throws IOException {
        ensureOpen();
        if (bitLength > INT_BITSIZE) {
            throw new IllegalArgumentException("overflow: " + bitLength);
        }
        if (remaining < bitLength) {
            fillBuffer(bitLength);
        }
        return buffer >>> (INT_BITSIZE - bitLength);
    }

    /**
     * ǂ݂B
     * @return ǂ݂(1oCg)l ǂݍ񂾒l <code>EOF</code> ̏ꍇ <code>-1</code>
     * @throws IOException o̓G[ꍇ
     */
    public int prefetch() throws IOException {
        return prefetchBits(INPUT_BITSIZE);
    }

    /**
     * obt@𖄂߂B
     * @param requiredSize vrbgTCY(obt@ɒǉTCYł͂Ȃ)
     * @throws IOException o̓G[ꍇ
     */
    private void fillBuffer(int requiredSize) throws IOException {
        assert requiredSize >= 1;
        if (requiredSize > INT_BITSIZE) {
            throw new IllegalArgumentException("overflow: " + requiredSize);
        }
        int buffered = 0;
        while (!eof && remaining < requiredSize) {
            int b = super.read();
            if (b == -1) {
                eof = true;
                return;
            }
            b <<= (INT_BITSIZE - INPUT_BITSIZE - remaining);
            assert (buffer | b) == buffer + b;
            buffer |= b;
            remaining += INPUT_BITSIZE;
            buffered += INPUT_BITSIZE;
        }
    }

    /**
     * obt@NAB
     */
    public void clearBuffer() {
        this.buffer = 0;
        this.remaining = 0;
    }

    /**
     * obt@l̎擾B
     * @return obt@l
     */
    public int getBuffer() {
        return buffer;
    }

    /**
     * obt@Lrbg̎擾B
     * @return Lrbg
     */
    public int getRemaining() {
        return remaining;
    }

    /**
     * ͂EOFɒBĂ邩ǂԂB
     * @return ͂EOFɒBĂȂ<code>true</code>AłȂ<code>false</code>
     */
    public boolean isEOF() {
        return eof;
    }

    /* (overridden)
     * @see java.io.FilterInputStream#read()
     */
    public int read() throws IOException {
        return readBits(8);
    }

    /* (overridden)
     * @see java.io.FilterInputStream#close()
     */
    public void close() throws IOException {
        ensureOpen();
        closed = true;
        super.close();
    }

}
