package jp.sourceforge.armadillo;

import java.io.*;

import jp.sourceforge.armadillo.io.*;
import jp.sourceforge.armadillo.zip.*;

/**
 * ZIP`A[JCu̓WJB
 */
public final class ZipExpander implements Expander {

    private ZipInputStream zis;

    /**
     * ZipExpander̐B
     * @param is InputStream
     */
    public ZipExpander(InputStream is) {
        this.zis = new ZipInputStream(is);
    }

    /**
     * ZipExpander̐B
     * @param zipFile ZIPt@C
     * @throws IOException o̓G[ꍇ 
     */
    public ZipExpander(File zipFile) throws IOException {
        this.zis = new ZipInputStream(zipFile);
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Expander#nextEntry()
     */
    public ArchiveEntry nextEntry() throws IOException {
        ZipEntry entry = zis.getNextEntry();
        if (entry == null) {
            return ArchiveEntry.NULL;
        }
        ArchiveEntry ae = new ArchiveEntry(entry.getName());
        ae.setMethod(getMethodName(entry.getMethod()));
        ae.setLastModified(entry.getLastModified());
        ae.setSize(entry.getSize());
        ae.setCompressedSize(entry.getCompressedSize());
        ae.setCrc(entry.getCrc());
        return ae;
    }

    /**
     * \bh̎擾B
     * @param method \bhl
     * @return \bh
     */
    private static String getMethodName(int method) {
        switch (method) {
            case ZipEntry.DEFLATED:
                return "DEFLATED";
            case ZipEntry.STORED:
                return "STORED";
            default:
                return "UNKNOWN";
        }
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Expander#expand(java.io.OutputStream)
     */
    public long expand(OutputStream os) throws IOException {
        return IOUtilities.transferAll(zis, os);
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Expander#close()
     */
    public void close() throws IOException {
        zis.close();
    }

}
